/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.resources;

import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.server.annotations.ResourceType;
import com.unboundid.scim2.server.utils.ResourcePreparer;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaAwareFilterEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceType(description="SCIM 2.0 Schema", name="Schema", schema=SchemaResource.class, discoverable=false)
@Path(value="Schemas")
public class SchemasEndpoint {
    private static final ResourceTypeDefinition RESOURCE_TYPE_DEFINITION = ResourceTypeDefinition.fromJaxRsResource(SchemasEndpoint.class);
    @Context
    private Application application;

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public ListResponse<GenericScimResource> search(@QueryParam(value="filter") String filterString, @Context UriInfo uriInfo) throws ScimException {
        if (filterString != null) {
            throw new ForbiddenException("Filtering not allowed");
        }
        ResourcePreparer<GenericScimResource> preparer = new ResourcePreparer<GenericScimResource>(RESOURCE_TYPE_DEFINITION, uriInfo);
        Collection<SchemaResource> schemas = this.getSchemas();
        ArrayList<GenericScimResource> preparedResources = new ArrayList<GenericScimResource>(schemas.size());
        for (SchemaResource schema : schemas) {
            GenericScimResource preparedResource = schema.asGenericScimResource();
            preparer.setResourceTypeAndLocation(preparedResource);
            preparedResources.add(preparedResource);
        }
        return new ListResponse(preparedResources);
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    public ScimResource get(@PathParam(value="id") String id, @Context UriInfo uriInfo) throws ScimException {
        Filter filter = Filter.or((Filter)Filter.eq((String)"id", (String)id), (Filter)Filter.eq((String)"name", (String)id), (Filter[])new Filter[0]);
        SchemaAwareFilterEvaluator filterEvaluator = new SchemaAwareFilterEvaluator(RESOURCE_TYPE_DEFINITION);
        ResourcePreparer<GenericScimResource> resourcePreparer = new ResourcePreparer<GenericScimResource>(RESOURCE_TYPE_DEFINITION, uriInfo);
        for (SchemaResource schema : this.getSchemas()) {
            GenericScimResource resource = schema.asGenericScimResource();
            if (!((Boolean)filter.visit((FilterVisitor)filterEvaluator, (Object)resource.getObjectNode())).booleanValue()) continue;
            resourcePreparer.setResourceTypeAndLocation(resource);
            return resource;
        }
        throw new ResourceNotFoundException("No schema defined with ID " + id);
    }

    public Collection<SchemaResource> getSchemas() throws ScimException {
        ResourceTypeDefinition resourceTypeDefinition;
        HashSet<SchemaResource> schemas = new HashSet<SchemaResource>();
        for (Class resourceClass : this.application.getClasses()) {
            resourceTypeDefinition = ResourceTypeDefinition.fromJaxRsResource(resourceClass);
            if (resourceTypeDefinition == null || !resourceTypeDefinition.isDiscoverable()) continue;
            if (resourceTypeDefinition.getCoreSchema() != null) {
                schemas.add(resourceTypeDefinition.getCoreSchema());
            }
            for (SchemaResource schemaExtension : resourceTypeDefinition.getSchemaExtensions().keySet()) {
                schemas.add(schemaExtension);
            }
        }
        for (Object resourceInstance : this.application.getSingletons()) {
            resourceTypeDefinition = ResourceTypeDefinition.fromJaxRsResource(resourceInstance.getClass());
            if (resourceTypeDefinition == null || !resourceTypeDefinition.isDiscoverable()) continue;
            if (resourceTypeDefinition.getCoreSchema() != null) {
                schemas.add(resourceTypeDefinition.getCoreSchema());
            }
            for (SchemaResource schemaExtension : resourceTypeDefinition.getSchemaExtensions().keySet()) {
                schemas.add(schemaExtension);
            }
        }
        return schemas;
    }
}

