/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaAwareFilterEvaluator;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SchemaAwareFilterEvaluatorTestCase {
    private ResourceTypeDefinition resourceTypeDefinition;
    private GenericScimResource testResource;

    @BeforeClass
    public void setUp() throws Exception {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>(4);
        AttributeDefinition.Builder builder = new AttributeDefinition.Builder();
        builder.setName("insensitive");
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setCaseExact(false);
        attributeDefinitions.add(builder.build());
        builder.setName("sensitive");
        builder.setCaseExact(true);
        attributeDefinitions.add(builder.build());
        SchemaResource schema = new SchemaResource("test", "test", "test", attributeDefinitions);
        this.resourceTypeDefinition = new ResourceTypeDefinition.Builder("test", "test").setCoreSchema(schema).build();
        ObjectNode node = (ObjectNode)JsonUtils.getObjectReader().readTree("{  \n  \"id\":\"test\",\n  \"insensitive\":\"HeRe\",\n  \"sensitive\":\"hErE\"\n}");
        this.testResource = new GenericScimResource(node);
    }

    @DataProvider(name="testValidFilterStrings")
    public Object[][] getTestValidFilterStrings() {
        return new Object[][]{{"insensitive eq \"here\"", true}, {"insensitive eq \"HERE\"", true}, {"insensitive eq \"HeRe\"", true}, {"insensitive eq \"nothere\"", false}, {"sensitive eq \"here\"", false}, {"sensitive eq \"HERE\"", false}, {"sensitive eq \"hErE\"", true}, {"sensitive eq \"nothere\"", false}};
    }

    @Test(dataProvider="getTestValidFilterStrings")
    public void testFilter(String filter, boolean result) throws ScimException {
        SchemaAwareFilterEvaluator filterEvaluator = new SchemaAwareFilterEvaluator(this.resourceTypeDefinition);
        boolean actualResult = (Boolean)Filter.fromString((String)filter).visit((FilterVisitor)filterEvaluator, (Object)this.testResource.getObjectNode());
        Assert.assertEquals((boolean)actualResult, (boolean)result);
    }
}

