/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server;

import com.unboundid.scim2.common.messages.ErrorResponse;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ServerUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestRequestFilter
implements ContainerRequestFilter {
    private MultivaluedMap<String, String> expectedHeaders = new MultivaluedHashMap();
    private MultivaluedMap<String, String> expectedQueryParams = new MultivaluedHashMap();

    TestRequestFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        this.validateRequest(requestContext, (MultivaluedMap<String, String>)headers, this.expectedHeaders, true);
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
        this.validateRequest(requestContext, (MultivaluedMap<String, String>)queryParams, this.expectedQueryParams, false);
    }

    void addExpectedHeader(String header, String value) {
        this.expectedHeaders.add((Object)header, (Object)value);
    }

    void addExpectedQueryParam(String queryParameter, String value) {
        this.expectedQueryParams.add((Object)queryParameter, (Object)value);
    }

    void reset() {
        this.expectedHeaders.clear();
        this.expectedQueryParams.clear();
    }

    private void validateRequest(ContainerRequestContext requestContext, MultivaluedMap<String, String> actual, MultivaluedMap<String, String> expected, boolean isCommaDelimited) {
        if (!expected.isEmpty()) {
            for (Map.Entry expectedEntry : expected.entrySet()) {
                List<String> actualValues;
                List actualEntry = (List)actual.get(expectedEntry.getKey());
                if (actualEntry != null && !actualEntry.isEmpty() && (actualValues = isCommaDelimited ? Arrays.asList(StaticUtils.splitCommaSeparatedString((String)((String)((List)actual.get(expectedEntry.getKey())).get(0)))) : (List<String>)actual.get(expectedEntry.getKey())).containsAll((Collection)expectedEntry.getValue())) continue;
                ErrorResponse errorResponse = this.errorResponse();
                requestContext.abortWith(ServerUtils.setAcceptableType((Response.ResponseBuilder)Response.status((int)errorResponse.getStatus()).entity((Object)errorResponse), (List)requestContext.getAcceptableMediaTypes()).build());
            }
        }
    }

    private ErrorResponse errorResponse() {
        return new ErrorResponse(Response.Status.BAD_REQUEST.getStatusCode());
    }
}

