/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.plugin.util;

import com.efs.sdk.plugin.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Utils {
    private static final String TAG = "Utils";
    public static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(is);
            Utils.closeQuietly(os);
            throw throwable;
        }
        Utils.closeQuietly(is);
        Utils.closeQuietly(os);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to close resource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRealZipOrJar(File input) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(input);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(zf);
                throw throwable;
            }
            Utils.closeQuietly(zf);
            return bl2;
        }
        Utils.closeQuietly(zf);
        return bl;
    }

    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof ZipFile) {
            try {
                ((ZipFile)obj).close();
            }
            catch (Throwable throwable) {}
        } else {
            throw new IllegalArgumentException("obj " + obj + " is not closeable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws Exception {
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[16384];
            int length = -1;
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                zipOutputStream.write(buffer, 0, length);
                zipOutputStream.flush();
            }
        }
        catch (ZipException e) {
            Log.e(TAG, "addZipEntry err!", new Object[0]);
        }
        finally {
            Utils.closeQuietly(inputStream);
            zipOutputStream.closeEntry();
        }
    }
}

