/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.plugin.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    public static final int LOG_LEVEL_VERBOSE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    private static LogImp debugLog;
    private static LogImp logImp;
    private static int level;

    private Log() {
    }

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void setLogLevel(String logLevel) {
        if (logLevel.equals("v")) {
            level = 0;
        } else if (logLevel.equals("d")) {
            level = 1;
        } else if (logLevel.equals("i")) {
            level = 2;
        } else if (logLevel.equals("w")) {
            level = 3;
        } else if (logLevel.equals("e")) {
            level = 4;
        }
        Log.getImpl().setLogLevel(level);
    }

    public static void v(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.v(tag, msg, obj);
        }
    }

    public static void e(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.e(tag, msg, obj);
        }
    }

    public static void w(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.w(tag, msg, obj);
        }
    }

    public static void i(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.i(tag, msg, obj);
        }
    }

    public static void d(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.d(tag, msg, obj);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null) {
            logImp.printErrStackTrace(tag, tr, format, obj);
        }
    }

    static {
        logImp = debugLog = new LogImp(){
            private int level = 2;

            @Override
            public void v(String tag, String msg, Object ... obj) {
                if (this.level == 0) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[VERBOSE][%s]%s", tag, log));
                }
            }

            @Override
            public void d(String tag, String msg, Object ... obj) {
                if (this.level <= 1) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[DEBUG][%s]%s", tag, log));
                }
            }

            @Override
            public void i(String tag, String msg, Object ... obj) {
                if (this.level <= 2) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[INFO][%s]%s", tag, log));
                }
            }

            @Override
            public void w(String tag, String msg, Object ... obj) {
                if (this.level <= 3) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[WARN][%s]%s", tag, log));
                }
            }

            @Override
            public void e(String tag, String msg, Object ... obj) {
                if (this.level <= 4) {
                    String log = obj == null ? msg : String.format(msg, obj);
                    System.out.println(String.format("[ERROR][%s]%s", tag, log));
                }
            }

            @Override
            public void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
                String log;
                String string = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                tr.printStackTrace(pw);
                log = log + "  " + sw.toString();
                System.out.println(String.format("[ERROR][%s]%s", tag, log));
            }

            @Override
            public void setLogLevel(int logLevel) {
                this.level = logLevel;
            }
        };
        level = 2;
    }

    public static interface LogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);

        public void setLogLevel(int var1);
    }
}

