/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.plugin;

import com.efs.sdk.plugin.EfsCollector;
import com.efs.sdk.plugin.util.Log;
import com.efs.sdk.plugin.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class EfsTracer {
    private static final String TAG = "EfsPluginTracer";
    private ConcurrentHashMap<String, String> collectedClassExtendMap;
    private List<String> whiteList;
    private List<String> blackList;

    public EfsTracer(ConcurrentHashMap<String, String> collectedClassExtendMap, List<String> whiteList, List<String> blackList) {
        this.collectedClassExtendMap = collectedClassExtendMap;
        this.whiteList = whiteList;
        this.blackList = blackList;
    }

    public void trace(Map<File, File> dirFileMap, Map<File, File> collectorJarFileMap) throws IOException {
        if (dirFileMap != null) {
            for (Map.Entry<File, File> entry : dirFileMap.entrySet()) {
                this.innerTraceMethodFromSrc(entry.getKey(), entry.getValue());
            }
        }
        if (collectorJarFileMap != null) {
            for (Map.Entry<File, File> entry : collectorJarFileMap.entrySet()) {
                this.innerTraceMethodFromJar(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromSrc(File input, File output) throws IOException {
        ArrayList<File> collectorDirClassFileList = new ArrayList<File>();
        if (input.isDirectory()) {
            this.listClassFiles(collectorDirClassFileList, input);
        } else {
            collectorDirClassFileList.add(input);
        }
        for (File classFile : collectorDirClassFileList) {
            InputStream is = null;
            FileOutputStream os = null;
            try {
                String changedFileInputFullPath = classFile.getAbsolutePath();
                File changedFileOutput = new File(changedFileInputFullPath.replace(input.getAbsolutePath(), output.getAbsolutePath()));
                if (!changedFileOutput.exists()) {
                    changedFileOutput.getParentFile().mkdirs();
                }
                changedFileOutput.createNewFile();
                if (EfsCollector.isNeedTraceFile(classFile.getName())) {
                    Log.i(TAG, "dir need trace file is " + classFile.getName(), new Object[0]);
                    is = new FileInputStream(classFile);
                    ClassReader classReader = new ClassReader(is);
                    ClassWriter classWriter = new ClassWriter(1);
                    TraceClassAdapter classVisitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)classVisitor, 8);
                    is.close();
                    os = output.isDirectory() ? new FileOutputStream(changedFileOutput) : new FileOutputStream(output);
                    os.write(classWriter.toByteArray());
                    os.close();
                    continue;
                }
                Utils.copyFileUsingStream(classFile, changedFileOutput);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e(TAG, "[innerTraceMethodFromSrc] input:%s e:%s", input.getName(), e);
                try {
                    Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    is.close();
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromJar(File input, File output) {
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(output));
            zipFile = new ZipFile(input);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (EfsCollector.isNeedTraceJarFile(zipEntryName, this.whiteList, this.blackList)) {
                    Log.i(TAG, "jar need trace file is " + zipEntryName, new Object[0]);
                    inputStream = zipFile.getInputStream(zipEntry);
                    ClassReader classReader = new ClassReader(inputStream);
                    ClassWriter classWriter = new ClassWriter(1);
                    TraceClassAdapter classVisitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)classVisitor, 8);
                    byte[] data = classWriter.toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                    ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                    Utils.addZipEntry(zipOutputStream, newZipEntry, byteArrayInputStream);
                    continue;
                }
                inputStream = zipFile.getInputStream(zipEntry);
                ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                Utils.addZipEntry(zipOutputStream, newZipEntry, inputStream);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "[innerTraceMethodFromJar] input:%s output:%s e:%s", input.getName(), output, e);
            try {
                Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.finish();
                    zipOutputStream.flush();
                    zipOutputStream.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                Log.e(TAG, "close stream err!", new Object[0]);
            }
        }
    }

    private void insertAppOnAttachMethod(ClassVisitor cv, String supername) {
        Log.i(TAG, "insert app onAttach Method", new Object[0]);
        MethodVisitor methodVisitor = cv.visitMethod(4, "attachBaseContext", "(Landroid/content/Context;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"app_attachBaseContext");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTraceApp", "(Landroid/app/Application;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, supername, "attachBaseContext", "(Landroid/content/Context;)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"app_attachBaseContext");
        methodVisitor.visitInsn(3);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTraceApp", "(Landroid/app/Application;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
    }

    private void insertAppOnCreateMethod(ClassVisitor cv, String supername) {
        Log.i(TAG, "insert app onCreate Method", new Object[0]);
        MethodVisitor methodVisitor = cv.visitMethod(1, "onCreate", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onCreate", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"app_onCreate");
        methodVisitor.visitInsn(3);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTraceApp", "(Landroid/app/Application;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void insertOnCreateMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onCreate", "(Landroid/os/Bundle;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"page_onCreate");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onCreate");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, supername, "onCreate", "(Landroid/os/Bundle;)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onCreate");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
    }

    private void insertOnRestartMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onRestart", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"page_onReStart");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onRestart", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void insertOnStartMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onStart", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"page_onStart");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onStart");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onStart", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onStart");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void insertOnResumeMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onResume", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onResume");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onResume", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onResume");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"page_onResume");
        methodVisitor.visitInsn(3);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void insertOnPauseMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onPause", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onPause");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onPause", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"onPause");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void insertOnStopMethod(ClassVisitor cv, String supername) {
        MethodVisitor methodVisitor = cv.visitMethod(4, "onStop", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"page_onStop");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, supername, "onStop", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    public static boolean isMatchingMethod(String name, String nameMatch, String desc, String descMatch) {
        return null != name && null != desc && name.equals(nameMatch) && desc.equals(descMatch);
    }

    private boolean isActivityOrSubClass(String className, ConcurrentHashMap<String, String> mCollectedClassExtendMap) {
        boolean isActivity;
        boolean bl = isActivity = (className = className.replace(".", "/")).equals("android/app/Activity") || className.equals("android/support/v4/app/FragmentActivity") || className.equals("android/support/v7/app/AppCompatActivity") || className.equals("androidx/appcompat/app/AppCompatActivity") || className.equals("androidx/fragment/app/FragmentActivity");
        if (isActivity) {
            return true;
        }
        if (!mCollectedClassExtendMap.containsKey(className)) {
            return false;
        }
        return this.isActivityOrSubClass(mCollectedClassExtendMap.get(className), mCollectedClassExtendMap);
    }

    private boolean isApplicationOrSubClass(String className, ConcurrentHashMap<String, String> mCollectedClassExtendMap) {
        boolean isApplication = (className = className.replace(".", "/")).equals("android/app/Application");
        if (isApplication) {
            return true;
        }
        if (!mCollectedClassExtendMap.containsKey(className)) {
            return false;
        }
        return this.isApplicationOrSubClass(mCollectedClassExtendMap.get(className), mCollectedClassExtendMap);
    }

    private void listClassFiles(List<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e(TAG, "[listClassFiles] files is null! %s", folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (null == file || !file.isFile()) continue;
            classFiles.add(file);
        }
    }

    private class TraceMethodAdapter
    extends AdviceAdapter {
        private final String name;
        private final String className;
        private final boolean isAppOnAttachMethod;
        private final boolean isAppOnCreateMethod;
        private final boolean isOnCreateMethod;
        private final boolean isOnRestartMethod;
        private final boolean isOnStartMethod;
        private final boolean isOnResumeMethod;
        private final boolean isOnPauseMethod;
        private final boolean isOnStopMethod;

        protected TraceMethodAdapter(int api, MethodVisitor mv, int access, String name, String desc, String className, boolean isAppOnCreateMethod, boolean isAppOnAttachMethod, boolean isOnCreateMethod, boolean isOnRestartMethod, boolean isOnStartMethod, boolean isOnResumeMethod, boolean isOnStopMethod, boolean isOnPauseMethod) {
            super(api, mv, access, name, desc);
            this.name = name;
            this.className = className;
            this.isAppOnAttachMethod = isAppOnAttachMethod;
            this.isAppOnCreateMethod = isAppOnCreateMethod;
            this.isOnCreateMethod = isOnCreateMethod;
            this.isOnRestartMethod = isOnRestartMethod;
            this.isOnStartMethod = isOnStartMethod;
            this.isOnResumeMethod = isOnResumeMethod;
            this.isOnPauseMethod = isOnPauseMethod;
            this.isOnStopMethod = isOnStopMethod;
        }

        protected void onMethodEnter() {
            if (this.isAppOnAttachMethod) {
                Log.i(EfsTracer.TAG, "method enter is app_attachBaseContext.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"app_attachBaseContext");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTraceApp", "(Landroid/app/Application;Ljava/lang/String;Z)V", false);
            } else if (this.isOnCreateMethod) {
                Log.i(EfsTracer.TAG, "method enter is page_onCreate.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"page_onCreate");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onCreate");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnRestartMethod) {
                Log.i(EfsTracer.TAG, "method enter is page_onReStart.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"page_onReStart");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
            } else if (this.isOnStartMethod) {
                Log.i(EfsTracer.TAG, "method enter is page_onStart.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"page_onStart");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onStart");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnStopMethod) {
                Log.i(EfsTracer.TAG, "method enter is page_onStop.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"page_onStop");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
            } else if (this.isOnResumeMethod) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onResume");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnPauseMethod) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onPause");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageBegin", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            }
        }

        protected void onMethodExit(int opcode) {
            if (this.isAppOnAttachMethod || this.isAppOnCreateMethod) {
                this.mv.visitVarInsn(25, 0);
                if (this.isAppOnAttachMethod) {
                    Log.i(EfsTracer.TAG, "method exit is app_attachBaseContext.", new Object[0]);
                    this.mv.visitLdcInsn((Object)"app_attachBaseContext");
                } else if (this.isAppOnCreateMethod) {
                    Log.i(EfsTracer.TAG, "method exit is app_onCreate.", new Object[0]);
                    this.mv.visitLdcInsn((Object)"app_onCreate");
                }
                this.mv.visitInsn(3);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTraceApp", "(Landroid/app/Application;Ljava/lang/String;Z)V", false);
            } else if (this.isOnResumeMethod) {
                Log.i(EfsTracer.TAG, "method exit is page_onResume.", new Object[0]);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"page_onResume");
                this.mv.visitInsn(3);
                this.mv.visitMethodInsn(184, "com/efs/sdk/launch/LaunchManager", "onTracePage", "(Landroid/app/Activity;Ljava/lang/String;Z)V", false);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onResume");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnCreateMethod) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onCreate");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnStartMethod) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onStart");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            } else if (this.isOnPauseMethod) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn((Object)"onPause");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "com/umeng/pagesdk/PageManger", "onTracePageEnd", "(Landroid/app/Activity;Ljava/lang/String;Z)V", true);
            }
        }
    }

    private class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private String superName;
        private boolean isAppOnAttachMethod;
        private boolean isAppOnCreateMethod;
        private boolean isOnCreateMethod;
        private boolean isOnRestartMethod;
        private boolean isOnStartMethod;
        private boolean isOnResumeMethod;
        private boolean isOnPauseMethod;
        private boolean isOnStopMethod;
        private boolean isWindowFocusMethod;
        private boolean hasAppOnAttachMethod;
        private boolean hasAppOnCreateMethod;
        private boolean hasOnCreateMethod;
        private boolean hasOnRestartMethod;
        private boolean hasOnStartMethod;
        private boolean hasOnResumeMethod;
        private boolean hasOnPauseMethod;
        private boolean hasOnStopMethod;
        private boolean hasWindowFocusMethod;
        private boolean isActivityOrSubClass;
        private boolean isApplicationOrSubClass;
        private boolean isNeedTrace;

        TraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
            this.isAppOnAttachMethod = false;
            this.isAppOnCreateMethod = false;
            this.isOnCreateMethod = false;
            this.isOnRestartMethod = false;
            this.isOnStartMethod = false;
            this.isOnResumeMethod = false;
            this.isOnPauseMethod = false;
            this.isOnStopMethod = false;
            this.isWindowFocusMethod = false;
            this.hasAppOnAttachMethod = false;
            this.hasAppOnCreateMethod = false;
            this.hasOnCreateMethod = false;
            this.hasOnRestartMethod = false;
            this.hasOnStartMethod = false;
            this.hasOnResumeMethod = false;
            this.hasOnPauseMethod = false;
            this.hasOnStopMethod = false;
            this.hasWindowFocusMethod = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.superName = superName;
            this.isActivityOrSubClass = EfsTracer.this.isActivityOrSubClass(this.className, EfsTracer.this.collectedClassExtendMap);
            this.isApplicationOrSubClass = EfsTracer.this.isApplicationOrSubClass(this.className, EfsTracer.this.collectedClassExtendMap);
            this.isNeedTrace = EfsCollector.isNeedTraceClass(this.className, EfsTracer.this.whiteList, EfsTracer.this.blackList);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isNeedTrace && (this.isActivityOrSubClass || this.isApplicationOrSubClass)) {
                Log.i(EfsTracer.TAG, "trace class is " + this.className, new Object[0]);
                if (this.isApplicationOrSubClass) {
                    this.isAppOnAttachMethod = EfsTracer.isMatchingMethod(name, "attachBaseContext", desc, "(Landroid/content/Context;)V");
                    if (!this.hasAppOnAttachMethod) {
                        this.hasAppOnAttachMethod = this.isAppOnAttachMethod;
                    }
                }
                this.isAppOnCreateMethod = EfsTracer.isMatchingMethod(name, "onCreate", desc, "()V");
                if (!this.hasAppOnCreateMethod) {
                    this.hasAppOnCreateMethod = this.isAppOnCreateMethod;
                }
                this.isOnCreateMethod = EfsTracer.isMatchingMethod(name, "onCreate", desc, "(Landroid/os/Bundle;)V");
                if (!this.hasOnCreateMethod) {
                    this.hasOnCreateMethod = this.isOnCreateMethod;
                }
                this.isOnRestartMethod = EfsTracer.isMatchingMethod(name, "onRestart", desc, "()V");
                if (!this.hasOnRestartMethod) {
                    this.hasOnRestartMethod = this.isOnRestartMethod;
                }
                this.isOnStartMethod = EfsTracer.isMatchingMethod(name, "onStart", desc, "()V");
                if (!this.hasOnStartMethod) {
                    this.hasOnStartMethod = this.isOnStartMethod;
                }
                this.isOnResumeMethod = EfsTracer.isMatchingMethod(name, "onResume", desc, "()V");
                if (!this.hasOnResumeMethod) {
                    this.hasOnResumeMethod = this.isOnResumeMethod;
                }
                this.isOnPauseMethod = EfsTracer.isMatchingMethod(name, "onPause", desc, "()V");
                if (!this.hasOnPauseMethod) {
                    this.hasOnPauseMethod = this.isOnPauseMethod;
                }
                this.isOnStopMethod = EfsTracer.isMatchingMethod(name, "onStop", desc, "()V");
                if (!this.hasOnStopMethod) {
                    this.hasOnStopMethod = this.isOnStopMethod;
                }
                this.isWindowFocusMethod = EfsTracer.isMatchingMethod(name, "onWindowFocusChanged", desc, "(Z)V");
                if (!this.hasWindowFocusMethod) {
                    this.hasWindowFocusMethod = this.isWindowFocusMethod;
                }
                MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
                return new TraceMethodAdapter(this.api, methodVisitor, access, name, desc, this.className, this.isAppOnCreateMethod, this.isAppOnAttachMethod, this.isOnCreateMethod, this.isOnRestartMethod, this.isOnStartMethod, this.isOnResumeMethod, this.isOnStopMethod, this.isOnPauseMethod);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            if (this.isNeedTrace && (this.isActivityOrSubClass || this.isApplicationOrSubClass)) {
                if (this.isApplicationOrSubClass) {
                    if (!this.hasAppOnAttachMethod) {
                        EfsTracer.this.insertAppOnAttachMethod(this.cv, this.superName);
                    }
                    if (!this.hasAppOnCreateMethod) {
                        EfsTracer.this.insertAppOnCreateMethod(this.cv, this.superName);
                    }
                } else if (this.isActivityOrSubClass) {
                    if (!this.hasOnCreateMethod) {
                        EfsTracer.this.insertOnCreateMethod(this.cv, this.superName);
                    }
                    if (!this.hasOnRestartMethod) {
                        EfsTracer.this.insertOnRestartMethod(this.cv, this.superName);
                    }
                    if (!this.hasOnStartMethod) {
                        EfsTracer.this.insertOnStartMethod(this.cv, this.superName);
                    }
                    if (!this.hasOnResumeMethod) {
                        EfsTracer.this.insertOnResumeMethod(this.cv, this.superName);
                    }
                    if (!this.hasOnPauseMethod) {
                        EfsTracer.this.insertOnPauseMethod(this.cv, this.superName);
                    }
                    if (!this.hasOnStopMethod) {
                        EfsTracer.this.insertOnStopMethod(this.cv, this.superName);
                    }
                }
            }
            super.visitEnd();
        }
    }
}

