/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.plugin;

import com.efs.sdk.plugin.EfsContent;
import com.efs.sdk.plugin.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class EfsCollector {
    private static final String TAG = "EfsPluginCollector";
    private final ConcurrentHashMap<String, String> collectedClassExtendMap = new ConcurrentHashMap();

    public ConcurrentHashMap<String, String> getCollectedClassExtendMap() {
        return this.collectedClassExtendMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void collect(Set<File> collectorDirFileList, Set<File> collectorJarFileList) {
        ArrayList<File> collectorDirClassFileList = new ArrayList<File>();
        for (File srcFile : collectorDirFileList) {
            if (srcFile.isDirectory()) {
                this.listClassFiles(collectorDirClassFileList, srcFile);
                continue;
            }
            collectorDirClassFileList.add(srcFile);
        }
        for (File classFile : collectorDirClassFileList) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(classFile);
                ClassReader classReader = new ClassReader((InputStream)is);
                ClassWriter classWriter = new ClassWriter(1);
                CollectorClassAdapter visitor = new CollectorClassAdapter(327680, (ClassVisitor)classWriter);
                classReader.accept((ClassVisitor)visitor, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        for (File jarFile : collectorJarFileList) {
            ZipFile zipFile = null;
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!EfsCollector.isNeedTraceFile(zipEntryName)) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                ClassReader classReader = new ClassReader(inputStream);
                ClassWriter classWriter = new ClassWriter(1);
                CollectorClassAdapter visitor = new CollectorClassAdapter(327680, (ClassVisitor)classWriter);
                classReader.accept((ClassVisitor)visitor, 0);
            }
            try {
                zipFile.close();
            }
            catch (Exception e) {
                Log.e(TAG, "close stream err! fromJar:%s", jarFile.getAbsolutePath());
            }
            continue;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception e2) {
                        Log.e(TAG, "close stream err! fromJar:%s", jarFile.getAbsolutePath());
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (Exception e3) {
                    Log.e(TAG, "close stream err! fromJar:%s", jarFile.getAbsolutePath());
                }
            }
        }
    }

    private void listClassFiles(List<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e(TAG, "[listClassFiles] files is null! %s", folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (!EfsCollector.isNeedTraceFile(file.getName())) continue;
            classFiles.add(file);
        }
    }

    public static boolean isNeedTraceFile(String fileName) {
        if (fileName.endsWith(".class")) {
            for (String unTraceCls : EfsContent.UN_TRACE_CLASS) {
                if (!fileName.contains(unTraceCls)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isNeedTraceJarFile(String fileName, List<String> whiteList, List<String> blackList) {
        if (fileName.endsWith(".class")) {
            for (String unTraceCls : EfsContent.UN_TRACE_CLASS) {
                if (!fileName.contains(unTraceCls)) continue;
                return false;
            }
        } else {
            return false;
        }
        fileName = fileName.replaceAll("/", ".");
        if (blackList != null) {
            for (String bName : blackList) {
                if (!fileName.startsWith(bName)) continue;
                return false;
            }
        }
        boolean isWhite = false;
        if (whiteList != null) {
            for (String wName : whiteList) {
                if (!fileName.startsWith(wName)) continue;
                isWhite = true;
                break;
            }
            return isWhite;
        }
        return true;
    }

    public static boolean isNeedTraceClass(String className, List<String> whiteList, List<String> blackList) {
        if (className == null) {
            return false;
        }
        className = className.replaceAll("/", ".");
        if (blackList != null) {
            for (String bName : blackList) {
                if (!className.startsWith(bName)) continue;
                return false;
            }
        }
        boolean isWhite = false;
        if (whiteList != null) {
            for (String wName : whiteList) {
                if (!className.startsWith(wName)) continue;
                isWhite = true;
                break;
            }
            return isWhite;
        }
        return true;
    }

    private class CollectorClassAdapter
    extends ClassVisitor {
        CollectorClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            EfsCollector.this.collectedClassExtendMap.put(name, superName);
        }
    }
}

