/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.coreutils.jwt;

import com.ufoscout.coreutils.jwt.JsonProvider;
import com.ufoscout.coreutils.jwt.JwtConfig;
import com.ufoscout.coreutils.jwt.JwtService;
import com.ufoscout.coreutils.jwt.TokenExpiredException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClock;
import java.util.Date;

public class JwtServiceJJWT
implements JwtService {
    static final String PAYLOAD_CLAIM_KEY = "payload";
    private final Clock clock = DefaultClock.INSTANCE;
    private final SignatureAlgorithm signatureAlgorithm;
    private String secret;
    private long tokenValidityMinutes;
    private final JsonProvider jsonProvider;

    public JwtServiceJJWT(JwtConfig jwtConfig, JsonProvider jsonSerializerService) {
        this.secret = jwtConfig.getSecret();
        this.signatureAlgorithm = SignatureAlgorithm.forName((String)jwtConfig.getSignatureAlgorithm());
        this.tokenValidityMinutes = jwtConfig.getTokenValidityMinutes();
        this.jsonProvider = jsonSerializerService;
    }

    @Override
    public <T> String generate(T payload) {
        return this.generate("", payload);
    }

    @Override
    public <T> String generate(String subject, T payload) {
        Date createdDate = this.clock.now();
        return this.generate(subject, payload, createdDate, this.calculateExpirationDate(createdDate));
    }

    @Override
    public <T> String generate(String subject, T payload, Date createdDate, Date expirationDate) {
        return Jwts.builder().setSubject(subject).claim(PAYLOAD_CLAIM_KEY, (Object)this.jsonProvider.toJson(payload)).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(this.signatureAlgorithm, this.secret).compact();
    }

    @Override
    public <T> T parse(String jwt, Class<T> payloadClass) {
        Claims claims = this.getAllClaimsFromToken(jwt);
        return this.jsonProvider.fromJson(payloadClass, (String)claims.get((Object)PAYLOAD_CLAIM_KEY));
    }

    private Date calculateExpirationDate(Date createdDate) {
        return new Date(createdDate.getTime() + this.tokenValidityMinutes * 60L * 1000L);
    }

    Claims getAllClaimsFromToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException e) {
            throw new TokenExpiredException();
        }
    }
}

