/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.coreutils.auth;

import com.ufoscout.coreutils.auth.AuthContext;
import com.ufoscout.coreutils.auth.AuthService;
import com.ufoscout.coreutils.auth.Role;
import com.ufoscout.coreutils.auth.RoleStore;
import com.ufoscout.coreutils.auth.RolesEncoder;
import com.ufoscout.coreutils.auth.RolesProvider;
import com.ufoscout.coreutils.auth.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServiceImpl<R>
implements AuthService<R> {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final RolesProvider provider;
    private final RolesEncoder<R> encoder;
    private volatile RoleStore store;

    public AuthServiceImpl(RolesProvider provider, RolesEncoder<R> encoder) {
        this.provider = provider;
        this.encoder = encoder;
    }

    @Override
    public void start() {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        AuthServiceImpl authServiceImpl = this;
        synchronized (authServiceImpl) {
            List<Role> newRoles = this.provider.getAll();
            int max = newRoles.stream().mapToInt(Role::getId).max().orElse(0);
            ArrayList<Role> roles = new ArrayList<Role>();
            HashMap rolesMap = new HashMap();
            Role[] rolesArray = new Role[max + 1];
            roles.addAll(this.provider.getAll());
            roles.forEach(role -> {
                rolesArray[role.getId()] = role;
                rolesMap.put(role.getName(), role);
            });
            this.store = new RoleStore(Collections.unmodifiableList(roles), Collections.unmodifiableMap(rolesMap), rolesArray);
        }
    }

    @Override
    public R encode(String ... roleNames) {
        return this.encoder.encode(this.store, roleNames);
    }

    @Override
    public List<Role> decode(R roles) {
        return this.encoder.decode(this.store, roles);
    }

    @Override
    public AuthContext<R> auth(User<R> user) {
        return new AuthContext<R>(user, this);
    }

    RoleStore getRolesStore() {
        return this.store;
    }
}

