/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.Strings;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayTimes;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.Times;

public class MonthTimes
implements Times {
    public static final String LAST = "last_day";
    public static final String FIRST = "first_day";
    public static final int[] DEFAULT_DAYS = new int[]{1};
    public static final DayTimes[] DEFAULT_TIMES = new DayTimes[]{new DayTimes()};
    private final int[] days;
    private final DayTimes[] times;

    public MonthTimes() {
        this(DEFAULT_DAYS, DEFAULT_TIMES);
    }

    public MonthTimes(int[] days, DayTimes[] times) {
        this.days = days.length == 0 ? DEFAULT_DAYS : days;
        Arrays.sort(this.days);
        this.times = times.length == 0 ? DEFAULT_TIMES : times;
        this.validate();
    }

    void validate() {
        for (int day : this.days) {
            if (day >= 1 && day <= 32) continue;
            throw Exceptions.illegalArgument("invalid month day [{}]", day);
        }
        for (DayTimes dayTimes : this.times) {
            dayTimes.validate();
        }
    }

    public int[] days() {
        return this.days;
    }

    public DayTimes[] times() {
        return this.times;
    }

    public Set<String> crons() {
        HashSet<String> crons = new HashSet<String>();
        for (DayTimes times : this.times) {
            String hrsStr = Strings.join(",", times.hour);
            String minsStr = Strings.join(",", times.minute);
            String daysStr = Strings.join(",", this.days);
            daysStr = daysStr.replace("32", "L");
            crons.add("0 " + minsStr + " " + hrsStr + " " + daysStr + " * ?");
        }
        return crons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthTimes that = (MonthTimes)o;
        if (!Arrays.equals(this.days, that.days)) {
            return false;
        }
        return Sets.newHashSet(this.times).equals(Sets.newHashSet(that.times));
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.days);
        result = 31 * result + Arrays.hashCode(this.times);
        return result;
    }

    public String toString() {
        return String.format(Locale.ROOT, "days [%s], times [%s]", Strings.join(",", this.days), org.elasticsearch.common.Strings.arrayToCommaDelimitedString(this.times));
    }

    public boolean contains(int day, DayTimes dayTimes) {
        if (Arrays.binarySearch(this.days, day) == -1) {
            return false;
        }
        for (DayTimes dayTimes1 : this.times()) {
            if (!dayTimes.equals(dayTimes1)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(MonthTimes testTimes) {
        for (int day : testTimes.days()) {
            for (DayTimes dayTimes : testTimes.times()) {
                if (!this.contains(day, dayTimes)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(DAY_FIELD.getPreferredName(), this.days);
        builder.startArray(TIME_FIELD.getPreferredName());
        for (DayTimes dayTimes : this.times) {
            dayTimes.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MonthTimes parse(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        DayTimes[] dayTimesArray;
        int[] days;
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse month times. expected an object, but found [{}]", new Object[]{token});
        }
        HashSet<Integer> daysSet = new HashSet<Integer>();
        HashSet<DayTimes> timesSet = new HashSet<DayTimes>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (DAY_FIELD.match(currentFieldName)) {
                if (token.isValue()) {
                    daysSet.add(MonthTimes.parseDayValue(parser, token));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        daysSet.add(MonthTimes.parseDayValue(parser, token));
                    }
                    continue;
                }
                throw new ElasticsearchParseException("invalid month day value for [{}] field. expected string/number value or an array of string/number values, but found [{}]", new Object[]{currentFieldName, token});
            }
            if (!TIME_FIELD.match(currentFieldName)) continue;
            if (token != XContentParser.Token.START_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                try {
                    timesSet.add(DayTimes.parse(parser, token));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{currentFieldName, token});
                }
            }
        }
        int[] nArray = days = daysSet.isEmpty() ? DEFAULT_DAYS : CollectionUtils.toArray(daysSet);
        if (timesSet.isEmpty()) {
            DayTimes[] dayTimesArray2 = new DayTimes[1];
            dayTimesArray = dayTimesArray2;
            dayTimesArray2[0] = new DayTimes(0, 0);
        } else {
            dayTimesArray = timesSet.toArray(new DayTimes[timesSet.size()]);
        }
        DayTimes[] times = dayTimesArray;
        return new MonthTimes(days, times);
    }

    static int parseDayValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            String value = parser.text().toLowerCase(Locale.ROOT);
            if (LAST.equals(value)) {
                return 32;
            }
            if (FIRST.equals(value)) {
                return 1;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new ElasticsearchParseException("invalid month day value. string value [{}] cannot be", value);
            }
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return parser.intValue();
        }
        throw new ElasticsearchParseException("invalid month day value. expected a string or a number value, but found [{}]", new Object[]{token});
    }

    public static class Builder {
        private final Set<Integer> days = new HashSet<Integer>();
        private final Set<DayTimes> times = new HashSet<DayTimes>();

        private Builder() {
        }

        public Builder on(int ... days) {
            Arrays.stream(days).forEach(this.days::add);
            return this;
        }

        public Builder at(int hour, int minute) {
            this.times.add(new DayTimes(hour, minute));
            return this;
        }

        public Builder atRoundHour(int ... hours) {
            this.times.add(new DayTimes(hours, new int[]{0}));
            return this;
        }

        public Builder atNoon() {
            this.times.add(DayTimes.NOON);
            return this;
        }

        public Builder atMidnight() {
            this.times.add(DayTimes.MIDNIGHT);
            return this;
        }

        public MonthTimes build() {
            return new MonthTimes(CollectionUtils.toArray(this.days), this.times.toArray(new DayTimes[this.times.size()]));
        }
    }
}

