/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public class CronSchedule
extends CronnableSchedule {
    public static final String TYPE = "cron";

    public CronSchedule(String ... crons) {
        super(crons);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.crons.length == 1 ? builder.value(this.crons[0]) : builder.value(this.crons);
    }

    public static class Parser
    implements Schedule.Parser<CronSchedule> {
        @Override
        public String type() {
            return CronSchedule.TYPE;
        }

        @Override
        public CronSchedule parse(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                try {
                    return new CronSchedule(parser.text());
                }
                catch (IllegalArgumentException iae) {
                    throw new ElasticsearchParseException("could not parse [cron] schedule", (Throwable)iae, new Object[0]);
                }
            }
            if (token == XContentParser.Token.START_ARRAY) {
                ArrayList<String> crons = new ArrayList<String>();
                block7: while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    switch (token) {
                        case VALUE_STRING: {
                            crons.add(parser.text());
                            continue block7;
                        }
                    }
                    throw new ElasticsearchParseException("could not parse [cron] schedule. expected a string value in the cron array but found [" + (Object)((Object)token) + "]", new Object[0]);
                }
                if (crons.isEmpty()) {
                    throw new ElasticsearchParseException("could not parse [cron] schedule. no cron expression found in cron array", new Object[0]);
                }
                try {
                    return new CronSchedule(crons.toArray(new String[crons.size()]));
                }
                catch (IllegalArgumentException iae) {
                    throw new ElasticsearchParseException("could not parse [cron] schedule", (Throwable)iae, new Object[0]);
                }
            }
            throw new ElasticsearchParseException("could not parse [cron] schedule. expected either a cron string value or an array of cron string values, but found [" + (Object)((Object)token) + "]", new Object[0]);
        }
    }
}

