/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.activate;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.watcher.support.validation.Validation;

public class ActivateWatchRequest
extends MasterNodeRequest<ActivateWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(10L);
    private String watchId;
    private boolean activate;

    public ActivateWatchRequest() {
        this(null, true);
    }

    public ActivateWatchRequest(String watchId, boolean activate) {
        this.watchId = watchId;
        this.activate = activate;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getWatchId() {
        return this.watchId;
    }

    public boolean isActivate() {
        return this.activate;
    }

    @Override
    public ActionRequestValidationException validate() {
        Validation.Error error;
        ActionRequestValidationException validationException = null;
        if (this.watchId == null) {
            validationException = ValidateActions.addValidationError("watch id is missing", validationException);
        }
        if ((error = Validation.watchId(this.watchId)) != null) {
            validationException = ValidateActions.addValidationError(error.message(), validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.watchId = in.readString();
        this.activate = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.watchId);
        out.writeBoolean(this.activate);
    }

    public String toString() {
        return this.activate ? "activate [" + this.watchId + "]" : "deactivate [" + this.watchId + "]";
    }
}

