/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestHijackOperationAction
extends WatcherRestHandler {
    private static final String ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING = "xpack.watcher.index.rest.direct_access";

    public RestHijackOperationAction(Settings settings, RestController controller) {
        super(settings);
        if (!settings.getAsBoolean(ALLOW_DIRECT_ACCESS_TO_WATCH_INDEX_SETTING, false).booleanValue()) {
            UnsupportedHandler unsupportedHandler = new UnsupportedHandler(settings);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch", this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}", this);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/{id}", this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/{id}/_update", this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/_query", this);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches/watch/{id}", this);
            controller.registerHandler(RestRequest.Method.GET, ".watches/watch/{id}", this);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_bulk", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_bulk", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/watch/_bulk", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.PUT, ".watches/_bulk", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.DELETE, ".watches", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_delete_by_query", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_delete_by_query", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/_update_by_query", unsupportedHandler);
            controller.registerHandler(RestRequest.Method.POST, ".watches/watch/_update_by_query", unsupportedHandler);
        }
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        if (request.hasParam("id")) {
            request.param("id");
        }
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
        jsonBuilder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index. Please use " + request.method().name() + " " + URI_BASE + "/watch/<watch_id> instead");
        jsonBuilder.field("status", RestStatus.BAD_REQUEST.getStatus());
        jsonBuilder.endObject();
        return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, jsonBuilder));
    }

    private static class UnsupportedHandler
    extends WatcherRestHandler {
        private UnsupportedHandler(Settings settings) {
            super(settings);
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
            if (request.hasParam("id")) {
                request.param("id");
            }
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.startObject().field("error", "This endpoint is not supported for " + request.method().name() + " on " + ".watches" + " index.");
            jsonBuilder.field("status", RestStatus.BAD_REQUEST.getStatus());
            jsonBuilder.endObject();
            return channel -> channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, jsonBuilder));
        }
    }
}

