/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.jira;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.jira.JiraService;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.jira.ExecutableJiraAction;
import org.elasticsearch.xpack.watcher.actions.jira.JiraAction;

public class JiraActionFactory
extends ActionFactory {
    private final TextTemplateEngine templateEngine;
    private final JiraService jiraService;

    public JiraActionFactory(Settings settings, TextTemplateEngine templateEngine, JiraService jiraService) {
        super(Loggers.getLogger(ExecutableJiraAction.class, settings, new String[0]));
        this.templateEngine = templateEngine;
        this.jiraService = jiraService;
    }

    @Override
    public ExecutableJiraAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        JiraAction action = JiraAction.parse(watchId, actionId, parser);
        this.jiraService.getAccount(action.getAccount());
        return new ExecutableJiraAction(action, this.actionLogger, this.jiraService, this.templateEngine);
    }
}

