/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.io.netty.handler.ssl.SslHandler;
import org.elasticsearch.jboss.netty.channel.Channel;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.KibanaUser;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3, ActionListener<Void> var4) throws IOException;

    public static class ClientProfile
    extends NodeProfile {
        ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext) {
            super(authcService, authzService, threadContext, extractClientCert, destructiveOperations, reservedRealmEnabled, securityContext);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction) {
                throw Exceptions.authenticationError("executing internal/shard actions is considered malicious and forbidden", new Object[0]);
            }
            super.inbound(action, request, transportChannel, listener);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final Logger logger = Loggers.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final SecurityActionMapper actionMapper = new SecurityActionMapper();
        private final ThreadContext threadContext;
        private final boolean extractClientCert;
        private final DestructiveOperations destructiveOperations;
        private final boolean reservedRealmEnabled;
        private final SecurityContext securityContext;

        NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.threadContext = threadContext;
            this.extractClientCert = extractClientCert;
            this.destructiveOperations = destructiveOperations;
            this.reservedRealmEnabled = reservedRealmEnabled;
            this.securityContext = securityContext;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
                IndicesRequest indicesRequest = (IndicesRequest)((Object)request);
                try {
                    this.destructiveOperations.failDestructive(indicesRequest.indices());
                }
                catch (IllegalArgumentException e) {
                    listener.onFailure(e);
                    return;
                }
            }
            String securityAction = this.actionMapper.action(action, request);
            TransportChannel unwrappedChannel = transportChannel;
            while (unwrappedChannel instanceof DelegatingTransportChannel) {
                unwrappedChannel = ((DelegatingTransportChannel)unwrappedChannel).getChannel();
            }
            if (this.extractClientCert && unwrappedChannel instanceof TcpTransportChannel) {
                if (((TcpTransportChannel)unwrappedChannel).getChannel() instanceof Channel) {
                    Channel channel = (Channel)((TcpTransportChannel)unwrappedChannel).getChannel();
                    org.elasticsearch.jboss.netty.handler.ssl.SslHandler sslHandler = channel.getPipeline().get(org.elasticsearch.jboss.netty.handler.ssl.SslHandler.class);
                    assert (sslHandler != null);
                    this.extactClientCertificates(sslHandler.getEngine(), channel);
                } else if (((TcpTransportChannel)unwrappedChannel).getChannel() instanceof org.elasticsearch.io.netty.channel.Channel) {
                    org.elasticsearch.io.netty.channel.Channel channel = (org.elasticsearch.io.netty.channel.Channel)((TcpTransportChannel)unwrappedChannel).getChannel();
                    SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
                    if (channel.isOpen()) {
                        assert (sslHandler != null) : "channel [" + channel + "] did not have a ssl handler. pipeline " + channel.pipeline();
                        this.extactClientCertificates(sslHandler.engine(), channel);
                    }
                }
            }
            this.authcService.authenticate(securityAction, request, null, ActionListener.wrap(authentication -> {
                if (this.reservedRealmEnabled && authentication.getVersion().before(Version.V_5_2_0_UNRELEASED) && "kibana".equals(authentication.getUser().principal())) {
                    KibanaUser kibanaUser = new KibanaUser(authentication.getUser().enabled());
                    if (!kibanaUser.enabled()) throw new IllegalStateException("a disabled user should never be sent. " + kibanaUser);
                    this.securityContext.executeAsUser(kibanaUser, original -> {
                        Authentication replacedUserAuth = Authentication.getAuthentication(this.threadContext);
                        AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer(replacedUserAuth, listener, (userRoles, runAsRoles) -> {
                            this.authzService.authorize(replacedUserAuth, securityAction, request, (Role)userRoles, (Role)runAsRoles);
                            listener.onResponse(null);
                        });
                        asyncAuthorizer.authorize(this.authzService);
                    });
                    return;
                } else {
                    AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer((Authentication)authentication, listener, (userRoles, runAsRoles) -> {
                        this.authzService.authorize((Authentication)authentication, securityAction, request, (Role)userRoles, (Role)runAsRoles);
                        listener.onResponse(null);
                    });
                    asyncAuthorizer.authorize(this.authzService);
                }
            }, listener::onFailure));
        }

        private void extactClientCertificates(SSLEngine sslEngine, Object channel) {
            block6: {
                try {
                    Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                    if (certs instanceof X509Certificate[]) {
                        this.threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", certs);
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    assert (!sslEngine.getNeedClientAuth());
                    assert (sslEngine.getWantClientAuth());
                    if (logger.isTraceEnabled()) {
                        logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", channel), (Throwable)e);
                    }
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("SSL Peer did not present a certificate on channel [{}]", channel);
                }
            }
        }
    }
}

