/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.user.SetEnabledResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class RestSetEnabledAction
extends BaseRestHandler {
    public RestSetEnabledAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_enable", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_enable", this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_disable", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_disable", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean enabled = request.path().endsWith("_enable");
        assert (enabled || request.path().endsWith("_disable"));
        String username = request.param("username");
        return channel -> new SecurityClient(client).prepareSetEnabled(username, enabled).execute(new RestBuilderListener<SetEnabledResponse>(channel){

            @Override
            public RestResponse buildResponse(SetEnabledResponse setEnabledResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }
}

