/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequestBuilder;
import org.elasticsearch.xpack.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.security.user.User;

public class RestChangePasswordAction
extends BaseRestHandler
implements RestRequestFilter {
    private final SecurityContext securityContext;
    private static final Set<String> FILTERED_FIELDS = Collections.singleton("password");

    public RestChangePasswordAction(Settings settings, RestController controller, SecurityContext securityContext) {
        super(settings);
        this.securityContext = securityContext;
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_password", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_password", this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/_password", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/_password", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        String username = request.param("username") == null ? (user.runAs() == null ? user.principal() : user.runAs().principal()) : request.param("username");
        String refresh = request.param("refresh");
        return channel -> ((ChangePasswordRequestBuilder)new SecurityClient(client).prepareChangePassword(username, request.content(), request.getXContentType()).setRefreshPolicy(refresh)).execute(new RestBuilderListener<ChangePasswordResponse>(channel){

            @Override
            public RestResponse buildResponse(ChangePasswordResponse changePasswordResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }

    @Override
    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

