/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class RestGetRolesAction
extends BaseRestHandler {
    public RestGetRolesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/role/", this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/role/{name}", this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/role", this, "[GET /_shield/role] is deprecated! Use [GET /_xpack/security/role] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/role/{name}", this, "[GET /_shield/role/{name}] is deprecated! Use [GET /_xpack/security/role/{name}] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] roles = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        return channel -> new SecurityClient(client).prepareGetRoles(roles).execute(new RestBuilderListener<GetRolesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetRolesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (RoleDescriptor role : response.roles()) {
                    builder.field(role.getName(), role);
                }
                builder.endObject();
                if (roles.length != 0 && response.roles().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

