/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.support.Automatons;

public final class ClusterPrivilege
extends Privilege {
    private static final Automaton MANAGE_SECURITY_AUTOMATON = Automatons.patterns("cluster:admin/xpack/security/*");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("cluster:monitor/*");
    private static final Automaton ALL_CLUSTER_AUTOMATON = Automatons.patterns("cluster:*", "indices:admin/template/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.minusAndMinimize(ALL_CLUSTER_AUTOMATON, MANAGE_SECURITY_AUTOMATON);
    private static final Automaton TRANSPORT_CLIENT_AUTOMATON = Automatons.patterns("cluster:monitor/nodes/liveness", "cluster:monitor/state");
    private static final Automaton MANAGE_IDX_TEMPLATE_AUTOMATON = Automatons.patterns("indices:admin/template/*");
    private static final Automaton MANAGE_INGEST_PIPELINE_AUTOMATON = Automatons.patterns("cluster:admin/ingest/pipeline/*");
    public static final ClusterPrivilege NONE = new ClusterPrivilege("none", Automatons.EMPTY);
    public static final ClusterPrivilege ALL = new ClusterPrivilege("all", ALL_CLUSTER_AUTOMATON);
    public static final ClusterPrivilege MONITOR = new ClusterPrivilege("monitor", MONITOR_AUTOMATON);
    public static final ClusterPrivilege MANAGE = new ClusterPrivilege("manage", MANAGE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_IDX_TEMPLATES = new ClusterPrivilege("manage_index_templates", MANAGE_IDX_TEMPLATE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_INGEST_PIPELINES = new ClusterPrivilege("manage_ingest_pipelines", MANAGE_INGEST_PIPELINE_AUTOMATON);
    public static final ClusterPrivilege TRANSPORT_CLIENT = new ClusterPrivilege("transport_client", TRANSPORT_CLIENT_AUTOMATON);
    public static final ClusterPrivilege MANAGE_SECURITY = new ClusterPrivilege("manage_security", MANAGE_SECURITY_AUTOMATON);
    public static final ClusterPrivilege MANAGE_PIPELINE = new ClusterPrivilege("manage_pipeline", "cluster:admin/ingest/pipeline/*");
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    private static final Map<String, ClusterPrivilege> VALUES = MapBuilder.newMapBuilder().put("none", NONE).put("all", ALL).put("monitor", MONITOR).put("manage", MANAGE).put("manage_index_templates", MANAGE_IDX_TEMPLATES).put("manage_ingest_pipelines", MANAGE_INGEST_PIPELINES).put("transport_client", TRANSPORT_CLIENT).put("manage_security", MANAGE_SECURITY).put("manage_pipeline", MANAGE_PIPELINE).immutableMap();
    private static final ConcurrentHashMap<Set<String>, ClusterPrivilege> CACHE = new ConcurrentHashMap();

    private ClusterPrivilege(String name, String ... patterns) {
        super(name, patterns);
    }

    private ClusterPrivilege(String name, Automaton automaton) {
        super(Collections.singleton(name), automaton);
    }

    private ClusterPrivilege(Set<String> name, Automaton automaton) {
        super(name, automaton);
    }

    public static ClusterPrivilege get(Set<String> name) {
        if (name == null || name.isEmpty()) {
            return NONE;
        }
        return CACHE.computeIfAbsent(name, ClusterPrivilege::resolve);
    }

    private static ClusterPrivilege resolve(Set<String> name) {
        int size = name.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<Automaton> automata = new HashSet<Automaton>();
        for (String part : name) {
            if (ACTION_MATCHER.test(part = part.toLowerCase(Locale.ROOT))) {
                actions.add(ClusterPrivilege.actionToPattern(part));
                continue;
            }
            ClusterPrivilege privilege = VALUES.get(part);
            if (privilege != null && size == 1) {
                return privilege;
            }
            if (privilege != null) {
                automata.add(privilege.automaton);
                continue;
            }
            throw new IllegalArgumentException("unknown cluster privilege [" + name + "]. a privilege must be either one of the predefined fixed cluster privileges [" + Strings.collectionToCommaDelimitedString(VALUES.entrySet()) + "] or a pattern over one of the available cluster actions");
        }
        if (!actions.isEmpty()) {
            automata.add(Automatons.patterns(actions));
        }
        return new ClusterPrivilege(name, Automatons.unionAndMinimize(automata));
    }
}

