/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.user.User;

public final class SetSecurityUserProcessor
extends AbstractProcessor {
    public static final String TYPE = "set_security_user";
    private final ThreadContext threadContext;
    private final String field;
    private final Set<Property> properties;

    SetSecurityUserProcessor(String tag, ThreadContext threadContext, String field, Set<Property> properties) {
        super(tag);
        this.threadContext = threadContext;
        this.field = field;
        this.properties = properties;
    }

    @Override
    public void execute(IngestDocument ingestDocument) throws Exception {
        Authentication authentication = Authentication.getAuthentication(this.threadContext);
        if (authentication == null) {
            throw new IllegalStateException("No user authenticated, only use this processor via authenticated user");
        }
        User user = authentication.getUser();
        if (user == null) {
            throw new IllegalStateException("No user for authentication");
        }
        HashMap<String, Object> userObject = new HashMap<String, Object>();
        block7: for (Property property : this.properties) {
            switch (property) {
                case USERNAME: {
                    if (user.principal() == null) continue block7;
                    userObject.put("username", user.principal());
                    continue block7;
                }
                case FULL_NAME: {
                    if (user.fullName() == null) continue block7;
                    userObject.put("full_name", user.fullName());
                    continue block7;
                }
                case EMAIL: {
                    if (user.email() == null) continue block7;
                    userObject.put("email", user.email());
                    continue block7;
                }
                case ROLES: {
                    if (user.roles() == null || user.roles().length == 0) continue block7;
                    userObject.put("roles", Arrays.asList(user.roles()));
                    continue block7;
                }
                case METADATA: {
                    if (user.metadata() == null || user.metadata().isEmpty()) continue block7;
                    userObject.put("metadata", user.metadata());
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("unsupported property [" + (Object)((Object)property) + "]");
        }
        ingestDocument.setFieldValue(this.field, userObject);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    static enum Property {
        USERNAME,
        FULL_NAME,
        EMAIL,
        ROLES,
        METADATA;


        static Property parse(String tag, String value) {
            try {
                return Property.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException(SetSecurityUserProcessor.TYPE, tag, "properties", "Property value [" + value + "] is in valid");
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final ThreadContext threadContext;

        public Factory(ThreadContext threadContext) {
            this.threadContext = threadContext;
        }

        @Override
        public SetSecurityUserProcessor create(Map<String, Processor.Factory> processorFactories, String tag, Map<String, Object> config) throws Exception {
            EnumSet<Property> properties;
            String field = ConfigurationUtils.readStringProperty(SetSecurityUserProcessor.TYPE, tag, config, "field");
            List<String> propertyNames = ConfigurationUtils.readOptionalList(SetSecurityUserProcessor.TYPE, tag, config, "properties");
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String propertyName : propertyNames) {
                    properties.add(Property.parse(tag, propertyName));
                }
            } else {
                properties = EnumSet.allOf(Property.class);
            }
            return new SetSecurityUserProcessor(tag, this.threadContext, field, properties);
        }
    }
}

