/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.xpack.security.authz.accesscontrol.FieldExtractor;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;

public final class OptOutQueryCache
extends AbstractIndexComponent
implements QueryCache {
    private final IndicesQueryCache indicesQueryCache;
    private final ThreadContext context;
    private final String indexName;

    public OptOutQueryCache(IndexSettings indexSettings, IndicesQueryCache indicesQueryCache, ThreadContext context) {
        super(indexSettings);
        this.indicesQueryCache = indicesQueryCache;
        this.context = Objects.requireNonNull(context, "threadContext must not be null");
        this.indexName = indexSettings.getIndex().getName();
    }

    @Override
    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    @Override
    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", (Object)reason);
        this.indicesQueryCache.clearIndex(this.index().getName());
    }

    @Override
    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.context.getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            this.logger.debug("opting out of the query cache. current request doesn't hold indices permissions");
            return weight;
        }
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(this.indexName);
        if (indexAccessControl != null && indexAccessControl.getFieldPermissions().hasFieldLevelSecurity()) {
            if (OptOutQueryCache.cachingIsSafe(weight, indexAccessControl)) {
                this.logger.trace("not opting out of the query cache. request for index [{}] is safe to cache", (Object)this.indexName);
                return this.indicesQueryCache.doCache(weight, policy);
            }
            this.logger.trace("opting out of the query cache. request for index [{}] is unsafe to cache", (Object)this.indexName);
            return weight;
        }
        this.logger.trace("not opting out of the query cache. request for index [{}] has field level security disabled", (Object)this.indexName);
        return this.indicesQueryCache.doCache(weight, policy);
    }

    static boolean cachingIsSafe(Weight weight, IndicesAccessControl.IndexAccessControl permissions) {
        HashSet<String> fields = new HashSet<String>();
        try {
            FieldExtractor.extractFields(weight.getQuery(), fields);
        }
        catch (UnsupportedOperationException ok) {
            return false;
        }
        for (String field : fields) {
            if (!field.startsWith("_") && permissions.getFieldPermissions().grantsAccessTo(field)) continue;
            return false;
        }
        return true;
    }
}

