/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.authz.AuthorizedIndices;

public class IndicesAndAliasesResolver {
    public static final String NO_INDEX_PLACEHOLDER = "-*";
    private static final Set<String> NO_INDEX_PLACEHOLDER_SET = Collections.singleton("-*");
    private static final String[] NO_INDICES_ARRAY = new String[]{"*", "-*"};
    static final List<String> NO_INDICES_LIST = Arrays.asList(NO_INDICES_ARRAY);
    private final IndexNameExpressionResolver nameExpressionResolver;

    public IndicesAndAliasesResolver(IndexNameExpressionResolver nameExpressionResolver) {
        this.nameExpressionResolver = nameExpressionResolver;
    }

    public Set<String> resolve(TransportRequest request, MetaData metaData, AuthorizedIndices authorizedIndices) {
        if (request instanceof IndicesAliasesRequest) {
            HashSet<String> indices = new HashSet<String>();
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            for (IndicesRequest indicesRequest : indicesAliasesRequest.getAliasActions()) {
                indices.addAll(this.resolveIndicesAndAliases(indicesRequest, metaData, authorizedIndices));
            }
            return indices;
        }
        if (!(request instanceof IndicesRequest)) {
            throw new IllegalStateException("Request [" + request + "] is not an Indices request, but should be.");
        }
        return this.resolveIndicesAndAliases((IndicesRequest)((Object)request), metaData, authorizedIndices);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> resolveIndicesAndAliases(IndicesRequest indicesRequest, MetaData metaData, AuthorizedIndices authorizedIndices) {
        void var5_24;
        boolean indicesReplacedWithNoIndices = false;
        if (indicesRequest instanceof PutMappingRequest && ((PutMappingRequest)indicesRequest).getConcreteIndex() != null) {
            assert (indicesRequest.indices() == null || indicesRequest.indices().length == 0) : "indices are: " + Arrays.toString(indicesRequest.indices());
            return Collections.singleton(((PutMappingRequest)indicesRequest).getConcreteIndex().getName());
        }
        if (indicesRequest instanceof IndicesRequest.Replaceable) {
            void var9_14;
            IndicesRequest.Replaceable replaceable = (IndicesRequest.Replaceable)indicesRequest;
            boolean replaceWildcards = indicesRequest.indicesOptions().expandWildcardsOpen() || indicesRequest.indicesOptions().expandWildcardsClosed();
            IndicesOptions indicesOptions = indicesRequest.indicesOptions();
            if (indicesRequest instanceof IndicesExistsRequest) {
                indicesOptions = IndicesOptions.fromOptions(true, true, indicesOptions.expandWildcardsOpen(), indicesOptions.expandWildcardsClosed());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
                if (replaceWildcards) {
                    for (String authorizedIndex : authorizedIndices.get()) {
                        if (!IndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                        arrayList.add(authorizedIndex);
                    }
                }
            } else {
                List<String> list = this.replaceWildcardsWithAuthorizedIndices(indicesRequest.indices(), indicesOptions, metaData, authorizedIndices.get(), replaceWildcards);
                if (indicesOptions.ignoreUnavailable()) {
                    List list2 = list.stream().filter(authorizedIndices.get()::contains).collect(Collectors.toList());
                }
            }
            if (var9_14.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) throw new IndexNotFoundException(Arrays.toString(indicesRequest.indices()));
                replaceable.indices(NO_INDICES_ARRAY);
                indicesReplacedWithNoIndices = true;
                Set<String> set = NO_INDEX_PLACEHOLDER_SET;
            } else {
                replaceable.indices(var9_14.toArray(new String[var9_14.size()]));
                HashSet hashSet = new HashSet(var9_14);
            }
        } else {
            void var9_16;
            if (this.containsWildcards(indicesRequest)) {
                throw new IllegalStateException("There are no external requests known to support wildcards that don't support replacing their indices");
            }
            ArrayList<String> resolvedNames = new ArrayList<String>();
            String[] replaceWildcards = indicesRequest.indices();
            int n = replaceWildcards.length;
            boolean bl = false;
            while (var9_16 < n) {
                String name = replaceWildcards[var9_16];
                resolvedNames.add(this.nameExpressionResolver.resolveDateMathExpression(name));
                ++var9_16;
            }
            HashSet hashSet = new HashSet(resolvedNames);
        }
        if (!(indicesRequest instanceof AliasesRequest)) return Collections.unmodifiableSet(var5_24);
        AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
        if (aliasesRequest.expandAliasesWildcards()) {
            List<String> aliases = this.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), this.loadAuthorizedAliases(authorizedIndices.get(), metaData));
            aliasesRequest.aliases(aliases.toArray(new String[aliases.size()]));
        }
        if (indicesReplacedWithNoIndices) {
            if (indicesRequest instanceof GetAliasesRequest) return Collections.unmodifiableSet(var5_24);
            throw new IllegalStateException(GetAliasesRequest.class.getSimpleName() + " is the only known request implementing " + AliasesRequest.class.getSimpleName() + " that may allow no indices. Found [" + indicesRequest.getClass().getName() + "] which ended up with an empty set of indices.");
        }
        Collections.addAll(var5_24, aliasesRequest.aliases());
        return Collections.unmodifiableSet(var5_24);
    }

    private List<String> loadAuthorizedAliases(List<String> authorizedIndices, MetaData metaData) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap<String, AliasOrIndex> existingAliases = metaData.getAliasAndIndexLookup();
        for (String authorizedIndex : authorizedIndices) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)existingAliases.get(authorizedIndex);
            if (aliasOrIndex == null || !aliasOrIndex.isAlias()) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        boolean matchAllAliases;
        ArrayList<String> finalAliases = new ArrayList<String>();
        boolean bl = matchAllAliases = aliases.length == 0;
        if (matchAllAliases) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasPattern : aliases) {
            if (aliasPattern.equals("_all")) {
                matchAllAliases = true;
                finalAliases.addAll(authorizedAliases);
                continue;
            }
            if (Regex.isSimpleMatchPattern(aliasPattern)) {
                for (String authorizedAlias : authorizedAliases) {
                    if (!Regex.simpleMatch(aliasPattern, authorizedAlias)) continue;
                    finalAliases.add(authorizedAlias);
                }
                continue;
            }
            finalAliases.add(aliasPattern);
        }
        if (finalAliases.isEmpty()) {
            String indexName = matchAllAliases ? "_all" : Arrays.toString(aliases);
            throw new IndexNotFoundException(indexName);
        }
        return finalAliases;
    }

    private boolean containsWildcards(IndicesRequest indicesRequest) {
        if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
            return true;
        }
        for (String index : indicesRequest.indices()) {
            if (!Regex.isSimpleMatchPattern(index)) continue;
            return true;
        }
        return false;
    }

    private List<String> replaceWildcardsWithAuthorizedIndices(String[] indices, IndicesOptions indicesOptions, MetaData metaData, List<String> authorizedIndices, boolean replaceWildcards) {
        ArrayList<String> finalIndices = new ArrayList<String>();
        boolean wildcardSeen = false;
        for (String index : indices) {
            String aliasOrIndex;
            boolean minus = false;
            if (index.charAt(0) == '+') {
                aliasOrIndex = index.substring(1);
            } else if (index.charAt(0) == '-') {
                if (wildcardSeen) {
                    aliasOrIndex = index.substring(1);
                    minus = true;
                } else {
                    aliasOrIndex = index;
                }
            } else {
                aliasOrIndex = index;
            }
            if (replaceWildcards && Regex.isSimpleMatchPattern(aliasOrIndex)) {
                wildcardSeen = true;
                HashSet<String> resolvedIndices = new HashSet<String>();
                for (String authorizedIndex : authorizedIndices) {
                    if (!Regex.simpleMatch(aliasOrIndex, authorizedIndex) || !IndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                    resolvedIndices.add(authorizedIndex);
                }
                if (resolvedIndices.isEmpty()) {
                    if (indicesOptions.allowNoIndices()) continue;
                    throw new IndexNotFoundException(aliasOrIndex);
                }
                if (minus) {
                    finalIndices.removeAll(resolvedIndices);
                    continue;
                }
                finalIndices.addAll(resolvedIndices);
                continue;
            }
            String dateMathName = this.nameExpressionResolver.resolveDateMathExpression(aliasOrIndex);
            if (dateMathName != aliasOrIndex) {
                assert (!dateMathName.equals(aliasOrIndex));
                if (authorizedIndices.contains(dateMathName) && IndicesAndAliasesResolver.isIndexVisible(dateMathName, indicesOptions, metaData, true)) {
                    if (minus) {
                        finalIndices.remove(dateMathName);
                        continue;
                    }
                    finalIndices.add(dateMathName);
                    continue;
                }
                if (indicesOptions.ignoreUnavailable()) continue;
                throw new IndexNotFoundException(dateMathName);
            }
            if (minus) {
                finalIndices.remove(aliasOrIndex);
                continue;
            }
            finalIndices.add(aliasOrIndex);
        }
        return finalIndices;
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData) {
        return IndicesAndAliasesResolver.isIndexVisible(index, indicesOptions, metaData, false);
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData, boolean dateMathExpression) {
        if (metaData.hasConcreteIndex(index)) {
            IndexMetaData indexMetaData = metaData.index(index);
            if (indexMetaData == null) {
                return true;
            }
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE && (indicesOptions.expandWildcardsClosed() || dateMathExpression)) {
                return true;
            }
            if (indexMetaData.getState() == IndexMetaData.State.OPEN && (indicesOptions.expandWildcardsOpen() || dateMathExpression)) {
                return true;
            }
        }
        return false;
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }
}

