/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class UserAttributeGroupsResolver
implements LdapSession.GroupsResolver {
    private static final Setting<String> ATTRIBUTE = new Setting("user_group_attribute", "memberOf", Function.identity(), Setting.Property.NodeScope);
    private final String attribute;

    UserAttributeGroupsResolver(Settings settings) {
        this(ATTRIBUTE.get(settings));
    }

    private UserAttributeGroupsResolver(String attribute) {
        this.attribute = Objects.requireNonNull(attribute);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        if (attributes != null) {
            List list = attributes.stream().filter(attr -> attr.getName().equals(this.attribute)).flatMap(attr -> Arrays.stream(attr.getValues())).collect(Collectors.toList());
            listener.onResponse(Collections.unmodifiableList(list));
        } else {
            LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), ActionListener.wrap(entry -> {
                if (entry == null || !entry.hasAttribute(this.attribute)) {
                    listener.onResponse(Collections.emptyList());
                } else {
                    listener.onResponse(Collections.unmodifiableList(Arrays.asList(entry.getAttributeValues(this.attribute))));
                }
            }, listener::onFailure), this.attribute);
        }
    }

    @Override
    public String[] attributes() {
        return new String[]{this.attribute};
    }

    public static Set<Setting<?>> getSettings() {
        return Collections.singleton(ATTRIBUTE);
    }
}

