/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.log4j.util.Supplier;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CharArrays;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.ssl.SSLService;

public class LdapSessionFactory
extends SessionFactory {
    public static final Setting<List<String>> USER_DN_TEMPLATES_SETTING = Setting.listSetting("user_dn_templates", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final String[] userDnTemplates;
    private final LdapSession.GroupsResolver groupResolver;

    public LdapSessionFactory(RealmConfig config, SSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        this.userDnTemplates = USER_DN_TEMPLATES_SETTING.get(settings).toArray(Strings.EMPTY_ARRAY);
        if (this.userDnTemplates.length == 0) {
            throw new IllegalArgumentException("missing required LDAP setting [" + RealmSettings.getFullSettingKey(config, USER_DN_TEMPLATES_SETTING) + "]");
        }
        this.groupResolver = LdapSessionFactory.groupResolver(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void session(String username, SecuredString password, ActionListener<LdapSession> listener) {
        lastException = null;
        connection = null;
        ldapSession = null;
        passwordBytes = CharArrays.toUtf8Bytes(password.internalChars());
        success = false;
        try {
            connection = this.serverSet.getConnection();
            for (String template : this.userDnTemplates) {
                dn = this.buildDnFromTemplate(username, template);
                try {
                    connection.bind(new SimpleBindRequest(dn, passwordBytes));
                    ldapSession = new LdapSession(this.logger, connection, dn, this.groupResolver, this.timeout, null);
                    success = true;
                    break;
                }
                catch (LDAPException e) {
                    this.logger.trace((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$session$0(java.lang.String java.lang.String ), ()Ljava/lang/Object;)((String)template, (String)dn), (Throwable)e);
                    if (lastException == null) {
                        lastException = e;
                        continue;
                    }
                    lastException.addSuppressed(e);
                }
            }
        }
        catch (LDAPException e) {
            try {
                if (!LdapSessionFactory.$assertionsDisabled && lastException != null) {
                    throw new AssertionError((Object)"if we catch a LDAPException here, we should have never seen another exception");
                }
                if (!LdapSessionFactory.$assertionsDisabled && ldapSession != null) {
                    throw new AssertionError((Object)"LDAPSession should not have been established due to a connection failure");
                }
                lastException = e;
            }
            catch (Throwable var15_16) {
                Arrays.fill(passwordBytes, (byte)0);
                if (!success) {
                    IOUtils.closeWhileHandlingException(new Closeable[]{connection});
                }
                throw var15_16;
            }
            Arrays.fill(passwordBytes, (byte)0);
            if (!success) {
                IOUtils.closeWhileHandlingException(new Closeable[]{connection});
            } else {
                ** GOTO lbl43
            }
        }
        Arrays.fill(passwordBytes, (byte)0);
        if (!success) {
            IOUtils.closeWhileHandlingException(new Closeable[]{connection});
        }
        if (ldapSession != null) {
            listener.onResponse(ldapSession);
        } else {
            if (!LdapSessionFactory.$assertionsDisabled && lastException == null) {
                throw new AssertionError((Object)"if there is not LDAPSession, then we must have a exception");
            }
            listener.onFailure(lastException);
        }
    }

    String buildDnFromTemplate(String username, String template) {
        String escapedUsername = LdapUtils.escapedRDNValue(username);
        return new MessageFormat(template, Locale.ROOT).format(new Object[]{escapedUsername}, new StringBuffer(), (FieldPosition)null).toString();
    }

    static LdapSession.GroupsResolver groupResolver(Settings settings) {
        if (SearchGroupsResolver.BASE_DN.exists(settings)) {
            return new SearchGroupsResolver(settings);
        }
        return new UserAttributeGroupsResolver(settings);
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.add(USER_DN_TEMPLATES_SETTING);
        return settings;
    }

    private static /* synthetic */ Object lambda$session$0(String template, String dn) {
        return new ParameterizedMessage("failed LDAP authentication with user template [{}] and DN [{}]", (Object)template, (Object)dn);
    }
}

