/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapUserSearchSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.ssl.SSLService;

public final class LdapRealm
extends CachingUsernamePasswordRealm {
    public static final String LDAP_TYPE = "ldap";
    public static final String AD_TYPE = "active_directory";
    static final Setting<TimeValue> EXECUTION_TIMEOUT = Setting.timeSetting("timeout.execution", TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope);
    private final SessionFactory sessionFactory;
    private final DnRoleMapper roleMapper;
    private final ThreadPool threadPool;
    private final TimeValue executionTimeout;

    public LdapRealm(String type, RealmConfig config, ResourceWatcherService watcherService, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        this(type, config, LdapRealm.sessionFactory(config, sslService, type), new DnRoleMapper(type, config, watcherService), threadPool);
    }

    LdapRealm(String type, RealmConfig config, SessionFactory sessionFactory, DnRoleMapper roleMapper, ThreadPool threadPool) {
        super(type, config);
        this.sessionFactory = sessionFactory;
        this.roleMapper = roleMapper;
        this.threadPool = threadPool;
        this.executionTimeout = EXECUTION_TIMEOUT.get(config.settings());
        roleMapper.addListener(this::expireAll);
    }

    static SessionFactory sessionFactory(RealmConfig config, SSLService sslService, String type) throws LDAPException {
        SessionFactory sessionFactory;
        if (AD_TYPE.equals(type)) {
            sessionFactory = new ActiveDirectorySessionFactory(config, sslService);
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [" + "active_directory" + ", " + "ldap" + "]";
            boolean hasSearchSettings = LdapUserSearchSessionFactory.hasUserSearchSettings(config);
            boolean hasTemplates = LdapSessionFactory.USER_DN_TEMPLATES_SETTING.exists(config.settings());
            if (!hasSearchSettings) {
                if (!hasTemplates) {
                    throw new IllegalArgumentException("settings were not found for either user search [" + RealmSettings.getFullSettingKey(config, "user_search.") + "] or user template [" + RealmSettings.getFullSettingKey(config, LdapSessionFactory.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please provide the settings for the mode you wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapSessionFactory(config, sslService);
            } else {
                if (hasTemplates) {
                    throw new IllegalArgumentException("settings were found for both user search [" + RealmSettings.getFullSettingKey(config, "user_search.") + "] and user template [" + RealmSettings.getFullSettingKey(config, LdapSessionFactory.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please remove the settings for the mode you do not wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapUserSearchSessionFactory(config, sslService);
            }
        }
        return sessionFactory;
    }

    public static Set<Setting<?>> getSettings(String type) {
        HashSet settings = new HashSet();
        settings.addAll(CachingUsernamePasswordRealm.getCachingSettings());
        DnRoleMapper.getSettings(settings);
        settings.add(EXECUTION_TIMEOUT);
        if (AD_TYPE.equals(type)) {
            settings.addAll(ActiveDirectorySessionFactory.getSettings());
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [" + "active_directory" + ", " + "ldap" + "]";
            settings.addAll(LdapSessionFactory.getSettings());
            settings.addAll(LdapUserSearchSessionFactory.getSettings());
        }
        return settings;
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<User> listener) {
        CancellableLdapRunnable cancellableLdapRunnable = new CancellableLdapRunnable(listener, () -> this.sessionFactory.session(token.principal(), token.credentials(), new LdapSessionActionListener("authenticate", token.principal(), listener, this.roleMapper, this.logger)), this.logger);
        this.threadPool.generic().execute(cancellableLdapRunnable);
        this.threadPool.schedule(this.executionTimeout, "same", cancellableLdapRunnable::maybeTimeout);
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (this.sessionFactory.supportsUnauthenticatedSession()) {
            CancellableLdapRunnable cancellableLdapRunnable = new CancellableLdapRunnable(listener, () -> this.sessionFactory.unauthenticatedSession(username, new LdapSessionActionListener("lookup", username, listener, this.roleMapper, this.logger)), this.logger);
            this.threadPool.generic().execute(cancellableLdapRunnable);
            this.threadPool.schedule(this.executionTimeout, "same", cancellableLdapRunnable::maybeTimeout);
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean userLookupSupported() {
        return this.sessionFactory.supportsUnauthenticatedSession();
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> usage = super.usageStats();
        usage.put("load_balance_type", LdapLoadBalancing.resolve(this.config.settings()).toString());
        usage.put("ssl", this.sessionFactory.isSslUsed());
        usage.put("user_search", LdapUserSearchSessionFactory.hasUserSearchSettings(this.config));
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupGroups(LdapSession session, String username, ActionListener<User> listener, DnRoleMapper roleMapper) {
        if (session == null) {
            listener.onResponse(null);
        } else {
            boolean loadingGroups = false;
            try {
                session.groups(ActionListener.wrap(groups -> {
                    Set<String> roles = roleMapper.resolveRoles(session.userDn(), (List<String>)groups);
                    IOUtils.close(session);
                    listener.onResponse(new User(username, roles.toArray(Strings.EMPTY_ARRAY)));
                }, e -> {
                    IOUtils.closeWhileHandlingException(session);
                    listener.onFailure((Exception)e);
                }));
                loadingGroups = true;
            }
            finally {
                if (!loadingGroups) {
                    session.close();
                }
            }
        }
    }

    static class CancellableLdapRunnable
    extends AbstractRunnable {
        private final Runnable in;
        private final ActionListener<User> listener;
        private final Logger logger;
        private final AtomicReference<LdapRunnableState> state = new AtomicReference<LdapRunnableState>(LdapRunnableState.AWAITING_EXECUTION);

        CancellableLdapRunnable(ActionListener<User> listener, Runnable in, Logger logger) {
            this.listener = listener;
            this.in = in;
            this.logger = logger;
        }

        @Override
        public void onFailure(Exception e) {
            this.logger.error("execution of ldap runnable failed", (Throwable)e);
            this.listener.onResponse(null);
        }

        @Override
        protected void doRun() throws Exception {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.EXECUTING)) {
                this.in.run();
            } else {
                this.logger.trace("skipping execution of ldap runnable as the current state is [{}]", (Object)this.state.get());
            }
        }

        @Override
        public void onRejection(Exception e) {
            this.listener.onFailure(e);
        }

        void maybeTimeout() {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.TIMED_OUT)) {
                this.logger.warn("skipping execution of ldap runnable as it has been waiting for execution too long");
                this.listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for execution of ldap runnable", new Object[0]));
            }
        }

        static enum LdapRunnableState {
            AWAITING_EXECUTION,
            EXECUTING,
            TIMED_OUT;

        }
    }

    private static class LdapSessionActionListener
    implements ActionListener<LdapSession> {
        private final AtomicReference<LdapSession> ldapSessionAtomicReference = new AtomicReference();
        private String action;
        private Logger logger;
        private final String username;
        private final ActionListener<User> userActionListener;
        private final DnRoleMapper roleMapper;

        LdapSessionActionListener(String action, String username, ActionListener<User> userActionListener, DnRoleMapper roleMapper, Logger logger) {
            this.action = action;
            this.username = username;
            this.userActionListener = userActionListener;
            this.roleMapper = roleMapper;
            this.logger = logger;
        }

        @Override
        public void onResponse(LdapSession session) {
            if (session == null) {
                this.userActionListener.onResponse(null);
            } else {
                this.ldapSessionAtomicReference.set(session);
                LdapRealm.lookupGroups(session, this.username, this.userActionListener, this.roleMapper);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (this.ldapSessionAtomicReference.get() != null) {
                IOUtils.closeWhileHandlingException(this.ldapSessionAtomicReference.get());
            }
            this.logger.info("{} failed for user [{}]: {}", (Object)this.action, (Object)this.username, (Object)e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(new ParameterizedMessage("{} failed", (Object)this.action), (Throwable)e);
            }
            this.userActionListener.onResponse(null);
        }
    }
}

