/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.logfile;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authz.privilege.SystemPrivilege;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.security.user.XPackUser;

public class LoggingAuditTrail
extends AbstractComponent
implements AuditTrail {
    public static final String NAME = "logfile";
    public static final Setting<Boolean> HOST_ADDRESS_SETTING = Setting.boolSetting(Security.setting("audit.logfile.prefix.emit_node_host_address"), false, Setting.Property.NodeScope);
    public static final Setting<Boolean> HOST_NAME_SETTING = Setting.boolSetting(Security.setting("audit.logfile.prefix.emit_node_host_name"), false, Setting.Property.NodeScope);
    public static final Setting<Boolean> NODE_NAME_SETTING = Setting.boolSetting(Security.setting("audit.logfile.prefix.emit_node_name"), true, Setting.Property.NodeScope);
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString());
    private static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.listSetting(Security.setting("audit.logfile.events.include"), DEFAULT_EVENT_INCLUDES, Function.identity(), Setting.Property.NodeScope);
    private static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.listSetting(Security.setting("audit.logfile.events.exclude"), Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting(Security.setting("audit.logfile.events.emit_request_body"), false, Setting.Property.NodeScope);
    private final Logger logger;
    private final ClusterService clusterService;
    private final ThreadContext threadContext;
    private final EnumSet<AuditLevel> events;
    private final boolean includeRequestBody;
    private String prefix;

    @Override
    public String name() {
        return NAME;
    }

    public LoggingAuditTrail(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        this(settings, clusterService, Loggers.getLogger(LoggingAuditTrail.class), threadPool.getThreadContext());
    }

    LoggingAuditTrail(Settings settings, ClusterService clusterService, Logger logger, ThreadContext threadContext) {
        super(settings);
        this.logger = logger;
        this.clusterService = clusterService;
        this.threadContext = threadContext;
        this.events = AuditLevel.parse(INCLUDE_EVENT_SETTINGS.get(settings), EXCLUDE_EVENT_SETTINGS.get(settings));
        this.includeRequestBody = INCLUDE_REQUEST_BODY.get(settings);
    }

    private String getPrefix() {
        if (this.prefix == null) {
            this.prefix = LoggingAuditTrail.resolvePrefix(this.settings, this.clusterService.localNode());
        }
        return this.prefix;
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params());
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            this.logger.info("{}[transport] [authentication_success]\t{}, {}, realm=[{}], action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)realm, (Object)action, (Object)message.getClass().getSimpleName());
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri());
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)token.principal(), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri());
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri());
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)realm, (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)token.principal(), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)realm, (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)realm, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}]", (Object)this.getPrefix(), (Object)realm, (Object)LoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri());
            }
        }
    }

    @Override
    public void accessGranted(User user, String action, TransportMessage message) {
        boolean shouldLog;
        boolean isSystem = SystemUser.is(user) && SystemPrivilege.INSTANCE.predicate().test(action) || XPackUser.is(user);
        boolean logSystemAccessGranted = isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED);
        boolean bl = shouldLog = logSystemAccessGranted || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED);
        if (shouldLog) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [access_granted]\t{}, {}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [access_granted]\t{}, {}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void accessDenied(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [access_denied]\t{}, {}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [access_denied]\t{}, {}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)request.uri());
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            String indices = LoggingAuditTrail.indicesString(message);
            if (indices != null) {
                this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)indices, (Object)message.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)action, (Object)message.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            String indices = LoggingAuditTrail.indicesString(request);
            if (indices != null) {
                this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], indices=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(request, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)indices, (Object)request.getClass().getSimpleName());
            } else {
                this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(request, this.clusterService.localNode(), this.threadContext), (Object)LoggingAuditTrail.principal(user), (Object)action, (Object)request.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED)) {
            this.logger.info("{}[ip_filter] [connection_granted]\torigin_address=[{}], transport_profile=[{}], rule=[{}]", (Object)this.getPrefix(), (Object)NetworkAddress.format(inetAddress), (Object)profile, (Object)rule);
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED)) {
            this.logger.info("{}[ip_filter] [connection_denied]\torigin_address=[{}], transport_profile=[{}], rule=[{}]", (Object)this.getPrefix(), (Object)NetworkAddress.format(inetAddress), (Object)profile, (Object)rule);
        }
    }

    @Override
    public void runAsGranted(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            this.logger.info("{}[transport] [run_as_granted]\t{}, principal=[{}], run_as_principal=[{}], action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)user.principal(), (Object)user.runAs().principal(), (Object)action, (Object)message.getClass().getSimpleName());
        }
    }

    @Override
    public void runAsDenied(User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            this.logger.info("{}[transport] [run_as_denied]\t{}, principal=[{}], run_as_principal=[{}], action=[{}], request=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.originAttributes(message, this.clusterService.localNode(), this.threadContext), (Object)user.principal(), (Object)user.runAs().principal(), (Object)action, (Object)message.getClass().getSimpleName());
        }
    }

    @Override
    public void runAsDenied(User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [run_as_denied]\t{}, principal=[{}], uri=[{}], request_body=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)user.principal(), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [run_as_denied]\t{}, principal=[{}], uri=[{}]", (Object)this.getPrefix(), (Object)LoggingAuditTrail.hostAttributes(request), (Object)user.principal(), (Object)request.uri());
            }
        }
    }

    private static String hostAttributes(RestRequest request) {
        SocketAddress socketAddress = request.getRemoteAddress();
        String formattedAddress = socketAddress instanceof InetSocketAddress ? NetworkAddress.format(((InetSocketAddress)socketAddress).getAddress()) : socketAddress.toString();
        return "origin_address=[" + formattedAddress + "]";
    }

    static String originAttributes(TransportMessage message, DiscoveryNode localNode, ThreadContext threadContext) {
        StringBuilder builder = new StringBuilder();
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
        if (restAddress != null) {
            builder.append("origin_type=[rest], origin_address=[").append(NetworkAddress.format(restAddress.getAddress())).append("]");
            return builder.toString();
        }
        TransportAddress address = message.remoteAddress();
        if (address != null) {
            builder.append("origin_type=[transport], ");
            if (address instanceof InetSocketTransportAddress) {
                builder.append("origin_address=[").append(NetworkAddress.format(((InetSocketTransportAddress)address).address().getAddress())).append("]");
            } else {
                builder.append("origin_address=[").append(address).append("]");
            }
            return builder.toString();
        }
        return builder.append("origin_type=[local_node], origin_address=[").append(localNode.getHostAddress()).append("]").toString();
    }

    static String resolvePrefix(Settings settings, DiscoveryNode localNode) {
        String name;
        String hostName;
        String address;
        StringBuilder builder = new StringBuilder();
        if (HOST_ADDRESS_SETTING.get(settings).booleanValue() && (address = localNode.getHostAddress()) != null) {
            builder.append("[").append(address).append("] ");
        }
        if (HOST_NAME_SETTING.get(settings).booleanValue() && (hostName = localNode.getHostName()) != null) {
            builder.append("[").append(hostName).append("] ");
        }
        if (NODE_NAME_SETTING.get(settings).booleanValue() && (name = settings.get("name")) != null) {
            builder.append("[").append(name).append("] ");
        }
        return builder.toString();
    }

    static String indicesString(TransportMessage message) {
        Set<String> indices = AuditUtil.indices(message);
        return indices == null ? null : Strings.collectionToCommaDelimitedString(indices);
    }

    static String principal(User user) {
        StringBuilder builder = new StringBuilder("principal=[");
        if (user.runAs() != null) {
            builder.append(user.runAs().principal()).append("], run_by_principal=[");
        }
        return builder.append(user.principal()).append("]").toString();
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(HOST_ADDRESS_SETTING);
        settings.add(HOST_NAME_SETTING);
        settings.add(NODE_NAME_SETTING);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
    }
}

