/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.user.AnonymousUser;

public class TransportChangePasswordAction
extends HandledTransportAction<ChangePasswordRequest, ChangePasswordResponse> {
    private final NativeUsersStore nativeUsersStore;

    @Inject
    public TransportChangePasswordAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore nativeUsersStore) {
        super(settings, "cluster:admin/xpack/security/user/change_password", threadPool, transportService, actionFilters, indexNameExpressionResolver, ChangePasswordRequest::new);
        this.nativeUsersStore = nativeUsersStore;
    }

    @Override
    protected void doExecute(ChangePasswordRequest request, final ActionListener<ChangePasswordResponse> listener) {
        String username = request.username();
        if (AnonymousUser.isAnonymousUsername(username, this.settings)) {
            listener.onFailure(new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified via the API"));
            return;
        }
        if ("_system".equals(username) || "_xpack".equals(username)) {
            listener.onFailure(new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        this.nativeUsersStore.changePassword(request, new ActionListener<Void>(){

            @Override
            public void onResponse(Void v) {
                listener.onResponse(new ChangePasswordResponse());
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

