/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.rest.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkRequestBuilder;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkResponse;
import org.elasticsearch.xpack.monitoring.rest.MonitoringRestHandler;

public class RestMonitoringBulkAction
extends MonitoringRestHandler {
    public static final String MONITORING_ID = "system_id";
    public static final String MONITORING_VERSION = "system_api_version";
    public static final String INTERVAL = "interval";

    public RestMonitoringBulkAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/_bulk", this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/_bulk", this);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/{type}/_bulk", this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/{type}/_bulk", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        String defaultType = request.param("type");
        String id = request.param(MONITORING_ID);
        if (Strings.isEmpty(id)) {
            throw new IllegalArgumentException("no [system_id] for monitoring bulk request");
        }
        String version = request.param(MONITORING_VERSION);
        if (Strings.isEmpty(version)) {
            throw new IllegalArgumentException("no [system_api_version] for monitoring bulk request");
        }
        if (Strings.isEmpty(request.param(INTERVAL))) {
            throw new IllegalArgumentException("no [interval] for monitoring bulk request");
        }
        if (!request.hasContentOrSourceParam()) {
            throw new ElasticsearchParseException("no body content for monitoring bulk request", new Object[0]);
        }
        MonitoringBulkRequestBuilder requestBuilder = client.monitoring().prepareMonitoringBulk();
        requestBuilder.add(request.content(), id, version, defaultType, request.getXContentType());
        return channel -> requestBuilder.execute(new RestBuilderListener<MonitoringBulkResponse>(channel){

            @Override
            public RestResponse buildResponse(MonitoringBulkResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("took", response.getTookInMillis());
                MonitoringBulkResponse.Error error = response.getError();
                builder.field("errors", error != null);
                if (error != null) {
                    builder.field("error", response.getError());
                }
                builder.endObject();
                return new BytesRestResponse(response.status(), builder);
            }
        });
    }

    @Override
    public boolean supportsContentStream() {
        return true;
    }

    static final class Fields {
        static final String TOOK = "took";
        static final String ERRORS = "errors";
        static final String ERROR = "error";

        Fields() {
        }
    }
}

