/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.cluster;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.License;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterInfoMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class ClusterInfoResolver
extends MonitoringIndexNameResolver.Data<ClusterInfoMonitoringDoc> {
    public static final String TYPE = "cluster_info";

    @Override
    public String type(ClusterInfoMonitoringDoc document) {
        return TYPE;
    }

    @Override
    public String id(ClusterInfoMonitoringDoc document) {
        return document.getClusterUUID();
    }

    @Override
    protected void buildXContent(ClusterInfoMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        List<XPackFeatureSet.Usage> usages;
        ClusterStatsResponse clusterStats;
        builder.field("cluster_name", document.getClusterName());
        builder.field("version", document.getVersion());
        License license = document.getLicense();
        if (license != null) {
            builder.startObject("license");
            Map<String, String> extraParams = new MapBuilder<String, String>().put("rest_view", "true").map();
            params = new ToXContent.DelegatingMapParams(extraParams, params);
            license.toInnerXContent(builder, params);
            builder.field("hkey", ClusterInfoResolver.hash(license, document.getClusterUUID()));
            builder.endObject();
        }
        if ((clusterStats = document.getClusterStats()) != null) {
            builder.startObject("cluster_stats");
            clusterStats.toXContent(builder, params);
            builder.endObject();
        }
        if ((usages = document.getUsage()) != null) {
            builder.startObject("stack_stats").startObject("xpack");
            for (XPackFeatureSet.Usage usage : usages) {
                builder.field(usage.name(), usage);
            }
            builder.endObject().endObject();
        }
    }

    public static String hash(License license, String clusterName) {
        return ClusterInfoResolver.hash(license.status().label(), license.uid(), license.type(), String.valueOf(license.expiryDate()), clusterName);
    }

    public static String hash(String licenseStatus, String licenseUid, String licenseType, String licenseExpiryDate, String clusterUUID) {
        String toHash = licenseStatus + licenseUid + licenseType + licenseExpiryDate + clusterUUID;
        return MessageDigests.toHexString(MessageDigests.sha256().digest(toHash.getBytes(StandardCharsets.UTF_8)));
    }
}

