/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.monitoring.action.MonitoringIndex;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterInfoMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStateMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStateNodeMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.cluster.DiscoveryNodeMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;
import org.elasticsearch.xpack.monitoring.resolver.bulk.MonitoringBulkDataResolver;
import org.elasticsearch.xpack.monitoring.resolver.bulk.MonitoringBulkTimestampedResolver;
import org.elasticsearch.xpack.monitoring.resolver.cluster.ClusterInfoResolver;
import org.elasticsearch.xpack.monitoring.resolver.cluster.ClusterStateNodeResolver;
import org.elasticsearch.xpack.monitoring.resolver.cluster.ClusterStateResolver;
import org.elasticsearch.xpack.monitoring.resolver.cluster.ClusterStatsResolver;
import org.elasticsearch.xpack.monitoring.resolver.cluster.DiscoveryNodeResolver;
import org.elasticsearch.xpack.monitoring.resolver.indices.IndexRecoveryResolver;
import org.elasticsearch.xpack.monitoring.resolver.indices.IndexStatsResolver;
import org.elasticsearch.xpack.monitoring.resolver.indices.IndicesStatsResolver;
import org.elasticsearch.xpack.monitoring.resolver.node.NodeStatsResolver;
import org.elasticsearch.xpack.monitoring.resolver.shards.ShardsResolver;

public class ResolversRegistry
implements Iterable<MonitoringIndexNameResolver> {
    private final List<Registration> registrations = new ArrayList<Registration>();

    public ResolversRegistry(Settings settings) {
        this.registerBuiltIn(MonitoredSystem.ES, settings);
        this.registerMonitoredSystem(MonitoredSystem.KIBANA, settings);
        this.registerMonitoredSystem(MonitoredSystem.LOGSTASH, settings);
    }

    private void registerBuiltIn(MonitoredSystem id, Settings settings) {
        this.registrations.add(ResolversRegistry.resolveByClass(ClusterInfoMonitoringDoc.class, new ClusterInfoResolver()));
        this.registrations.add(ResolversRegistry.resolveByClass(ClusterStateNodeMonitoringDoc.class, new ClusterStateNodeResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(ClusterStateMonitoringDoc.class, new ClusterStateResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(ClusterStatsMonitoringDoc.class, new ClusterStatsResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(DiscoveryNodeMonitoringDoc.class, new DiscoveryNodeResolver()));
        this.registrations.add(ResolversRegistry.resolveByClass(IndexRecoveryMonitoringDoc.class, new IndexRecoveryResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(IndexStatsMonitoringDoc.class, new IndexStatsResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(IndicesStatsMonitoringDoc.class, new IndicesStatsResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(NodeStatsMonitoringDoc.class, new NodeStatsResolver(id, settings)));
        this.registrations.add(ResolversRegistry.resolveByClass(ShardMonitoringDoc.class, new ShardsResolver(id, settings)));
    }

    private void registerMonitoredSystem(MonitoredSystem id, Settings settings) {
        MonitoringBulkDataResolver dataResolver = new MonitoringBulkDataResolver();
        MonitoringBulkTimestampedResolver timestampedResolver = new MonitoringBulkTimestampedResolver(id, settings);
        String currentApiVersion = "2";
        this.registrations.add(ResolversRegistry.resolveByClassSystemVersion(id, dataResolver, MonitoringIndex.DATA, "2"));
        this.registrations.add(ResolversRegistry.resolveByClassSystemVersion(id, timestampedResolver, MonitoringIndex.TIMESTAMPED, "2"));
    }

    public MonitoringIndexNameResolver getResolver(MonitoringDoc document) {
        for (Registration registration : this.registrations) {
            if (!registration.support(document)) continue;
            return registration.resolver();
        }
        throw new IllegalArgumentException("No resolver found for monitoring document");
    }

    @Override
    public Iterator<MonitoringIndexNameResolver> iterator() {
        return this.registrations.stream().map(Registration::resolver).iterator();
    }

    static Registration resolveByClass(Class<? extends MonitoringDoc> type, MonitoringIndexNameResolver resolver) {
        return new Registration(resolver, type::isInstance);
    }

    static Registration resolveByClassSystemVersion(MonitoredSystem system, MonitoringIndexNameResolver resolver, MonitoringIndex index, String apiVersion) {
        return new Registration(resolver, doc -> {
            try {
                if (!(doc instanceof MonitoringBulkDoc) || index != ((MonitoringBulkDoc)doc).getIndex()) {
                    return false;
                }
                if (system != MonitoredSystem.fromSystem(doc.getMonitoringId())) {
                    return false;
                }
                return apiVersion.equals(doc.getMonitoringVersion());
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    static class Registration {
        private final MonitoringIndexNameResolver resolver;
        private final Predicate<MonitoringDoc> predicate;

        Registration(MonitoringIndexNameResolver resolver, Predicate<MonitoringDoc> predicate) {
            this.resolver = Objects.requireNonNull(resolver);
            this.predicate = Objects.requireNonNull(predicate);
        }

        boolean support(MonitoringDoc document) {
            return this.predicate.test(document);
        }

        MonitoringIndexNameResolver resolver() {
            return this.resolver;
        }
    }
}

