/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringTemplateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class MonitoringIndexNameResolver<T extends MonitoringDoc> {
    public static final String PREFIX = ".monitoring";
    public static final String DELIMITER = "-";

    public abstract String index(T var1);

    public abstract String indexPattern();

    public abstract String type(T var1);

    public abstract String id(T var1);

    public BytesReference source(T document, XContentType xContentType) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            try (XContentBuilder builder = new XContentBuilder(xContentType.xContent(), out, this.filters());){
                builder.startObject();
                builder.field("cluster_uuid", ((MonitoringDoc)document).getClusterUUID());
                DateTime timestampDateTime = new DateTime(((MonitoringDoc)document).getTimestamp(), DateTimeZone.UTC);
                builder.field("timestamp", timestampDateTime.toString());
                MonitoringDoc.Node sourceNode = ((MonitoringDoc)document).getSourceNode();
                if (sourceNode != null) {
                    builder.field("source_node", sourceNode);
                }
                this.buildXContent(document, builder, ToXContent.EMPTY_PARAMS);
                builder.endObject();
            }
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
    }

    public abstract String templateName();

    public abstract String template();

    public Set<String> filters() {
        return Collections.emptySet();
    }

    protected abstract void buildXContent(T var1, XContentBuilder var2, ToXContent.Params var3) throws IOException;

    public static abstract class Timestamped<T extends MonitoringDoc>
    extends MonitoringIndexNameResolver<T> {
        public static final Setting<String> INDEX_NAME_TIME_FORMAT_SETTING = new Setting("index.name.time_format", "YYYY.MM.dd", Function.identity(), Setting.Property.NodeScope);
        private final MonitoredSystem system;
        private final DateTimeFormatter formatter;
        private final String index;

        public Timestamped(MonitoredSystem system, Settings settings) {
            this(system, settings, "2");
        }

        protected Timestamped(MonitoredSystem system, Settings settings, String version) {
            this.system = system;
            this.index = String.join((CharSequence)MonitoringIndexNameResolver.DELIMITER, MonitoringIndexNameResolver.PREFIX, system.getSystem(), version);
            String format = INDEX_NAME_TIME_FORMAT_SETTING.get(settings);
            try {
                this.formatter = DateTimeFormat.forPattern(format).withZoneUTC();
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("invalid index name time format [" + format + "]", e);
            }
        }

        @Override
        public String index(T document) {
            return String.join((CharSequence)MonitoringIndexNameResolver.DELIMITER, this.index, this.formatter.print(((MonitoringDoc)document).getTimestamp()));
        }

        @Override
        public String indexPattern() {
            return String.join((CharSequence)MonitoringIndexNameResolver.DELIMITER, this.index, "*");
        }

        @Override
        public String id(T document) {
            return null;
        }

        @Override
        public String templateName() {
            return String.format(Locale.ROOT, "%s-%s-%s", MonitoringIndexNameResolver.PREFIX, this.getId(), "2");
        }

        @Override
        public String template() {
            return MonitoringTemplateUtils.loadTemplate(this.getId());
        }

        String getId() {
            return this.system.getSystem();
        }
    }

    public static abstract class Data<T extends MonitoringDoc>
    extends MonitoringIndexNameResolver<T> {
        public static final String DATA = "data";
        private final String index;

        public Data() {
            this("2");
        }

        protected Data(String version) {
            this.index = String.join((CharSequence)MonitoringIndexNameResolver.DELIMITER, MonitoringIndexNameResolver.PREFIX, DATA, version);
        }

        @Override
        public String index(T document) {
            return this.index;
        }

        @Override
        public String indexPattern() {
            return this.index;
        }

        @Override
        public String templateName() {
            return String.format(Locale.ROOT, "%s-%s-%s", MonitoringIndexNameResolver.PREFIX, DATA, "2");
        }

        @Override
        public String template() {
            return MonitoringTemplateUtils.loadTemplate(DATA);
        }
    }

    public static final class Fields {
        public static final String CLUSTER_UUID = "cluster_uuid";
        public static final String TIMESTAMP = "timestamp";
        public static final String SOURCE_NODE = "source_node";
    }
}

