/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.shards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class ShardsCollector
extends Collector {
    public static final String NAME = "shards-collector";

    public ShardsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState) {
        super(settings, NAME, clusterService, monitoringSettings, licenseState);
    }

    @Override
    protected boolean shouldCollect() {
        return super.shouldCollect() && this.isLocalNodeMaster();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        List<ShardRouting> shards;
        RoutingTable routingTable;
        ArrayList<ShardMonitoringDoc> results = new ArrayList<ShardMonitoringDoc>(1);
        ClusterState clusterState = this.clusterService.state();
        if (clusterState != null && (routingTable = clusterState.routingTable()) != null && (shards = routingTable.allShards()) != null) {
            String clusterUUID = this.clusterUUID();
            String stateUUID = clusterState.stateUUID();
            long timestamp = System.currentTimeMillis();
            for (ShardRouting shard : shards) {
                if (!this.match(shard.getIndexName())) continue;
                ShardMonitoringDoc shardDoc = new ShardMonitoringDoc(ShardsCollector.monitoringId(), ShardsCollector.monitoringVersion());
                shardDoc.setClusterUUID(clusterUUID);
                shardDoc.setTimestamp(timestamp);
                if (shard.assignedToNode()) {
                    shardDoc.setSourceNode(clusterState.getNodes().get(shard.currentNodeId()));
                }
                shardDoc.setShardRouting(shard);
                shardDoc.setClusterStateUUID(stateUUID);
                results.add(shardDoc);
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    private boolean match(String indexName) {
        String[] indices = this.monitoringSettings.indices();
        return IndexNameExpressionResolver.isAllIndices(Arrays.asList(this.monitoringSettings.indices())) || Regex.simpleMatch(indices, indexName);
    }
}

