/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.license.LicensingClient;
import org.elasticsearch.license.XPackInfoResponse;
import org.elasticsearch.xpack.action.XPackInfoAction;
import org.elasticsearch.xpack.action.XPackInfoRequest;
import org.elasticsearch.xpack.action.XPackInfoRequestBuilder;
import org.elasticsearch.xpack.monitoring.client.MonitoringClient;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.watcher.client.WatcherClient;

public class XPackClient {
    private final Client client;
    private final LicensingClient licensingClient;
    private final MonitoringClient monitoringClient;
    private final SecurityClient securityClient;
    private final WatcherClient watcherClient;

    public XPackClient(Client client) {
        this.client = client;
        this.licensingClient = new LicensingClient(client);
        this.monitoringClient = new MonitoringClient(client);
        this.securityClient = new SecurityClient(client);
        this.watcherClient = new WatcherClient(client);
    }

    public Client es() {
        return this.client;
    }

    public LicensingClient licensing() {
        return this.licensingClient;
    }

    public MonitoringClient monitoring() {
        return this.monitoringClient;
    }

    public SecurityClient security() {
        return this.securityClient;
    }

    public WatcherClient watcher() {
        return this.watcherClient;
    }

    public XPackClient withHeaders(Map<String, String> headers) {
        return new XPackClient(this.client.filterWithHeader(headers));
    }

    public XPackClient withAuth(String username, char[] passwd) {
        return this.withHeaders(Collections.singletonMap("Authorization", UsernamePasswordToken.basicAuthHeaderValue(username, new SecuredString(passwd))));
    }

    public XPackInfoRequestBuilder prepareInfo() {
        return new XPackInfoRequestBuilder(this.client);
    }

    public void info(XPackInfoRequest request, ActionListener<XPackInfoResponse> listener) {
        this.client.execute(XPackInfoAction.INSTANCE, request, listener);
    }
}

