/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class FieldSortBuilder
extends SortBuilder<FieldSortBuilder> {
    public static final String NAME = "field_sort";
    public static final ParseField MISSING = new ParseField("missing", new String[0]);
    public static final ParseField SORT_MODE = new ParseField("mode", new String[0]);
    public static final ParseField UNMAPPED_TYPE = new ParseField("unmapped_type", new String[0]);
    public static final String DOC_FIELD_NAME = "_doc";
    private static final SortFieldAndFormat SORT_DOC = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_DOC_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC, true), DocValueFormat.RAW);
    private final String fieldName;
    private Object missing;
    private String unmappedType;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private static ObjectParser<FieldSortBuilder, QueryParseContext> PARSER = new ObjectParser("field_sort");

    public FieldSortBuilder(FieldSortBuilder template) {
        this(template.fieldName);
        this.order(template.order());
        this.missing(template.missing());
        this.unmappedType(template.unmappedType());
        if (template.sortMode != null) {
            this.sortMode(template.sortMode());
        }
        this.setNestedFilter(template.getNestedFilter());
        this.setNestedPath(template.getNestedPath());
    }

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public FieldSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedPath = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.order = in.readOptionalWriteable(SortOrder::readFromStream);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.unmappedType = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalNamedWriteable(this.nestedFilter);
        out.writeOptionalString(this.nestedPath);
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.order);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.unmappedType);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public FieldSortBuilder unmappedType(String type) {
        this.unmappedType = type;
        return this;
    }

    public String unmappedType() {
        return this.unmappedType;
    }

    public FieldSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public FieldSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        this.nestedFilter = nestedFilter;
        return this;
    }

    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    public FieldSortBuilder setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
        return this;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.fieldName);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.missing != null) {
            builder.field(MISSING.getPreferredName(), this.missing);
        }
        if (this.unmappedType != null) {
            builder.field(UNMAPPED_TYPE.getPreferredName(), this.unmappedType);
        }
        if (this.sortMode != null) {
            builder.field(SORT_MODE.getPreferredName(), this.sortMode);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), this.nestedFilter, params);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        boolean reverse;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            if (this.order == SortOrder.DESC) {
                return SORT_DOC_REVERSE;
            }
            return SORT_DOC;
        }
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.unmappedType != null) {
                fieldType = context.getMapperService().unmappedFieldType(this.unmappedType);
            } else {
                throw new QueryShardException(context, "No mapping found for [" + this.fieldName + "] in order to sort on", new Object[0]);
            }
        }
        MultiValueMode localSortMode = null;
        if (this.sortMode != null) {
            localSortMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        boolean bl = reverse = this.order == SortOrder.DESC;
        if (localSortMode == null) {
            localSortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        IndexFieldData.XFieldComparatorSource.Nested nested = FieldSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        Object fieldData = context.getForField(fieldType);
        if (!(fieldData instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException(context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        IndexFieldData.XFieldComparatorSource fieldComparatorSource = fieldData.comparatorSource(this.missing, localSortMode, nested);
        SortField field = new SortField(fieldType.name(), fieldComparatorSource, reverse);
        return new SortFieldAndFormat(field, fieldType.docValueFormat(null, null));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSortBuilder builder = (FieldSortBuilder)other;
        return Objects.equals(this.fieldName, builder.fieldName) && Objects.equals(this.nestedFilter, builder.nestedFilter) && Objects.equals(this.nestedPath, builder.nestedPath) && Objects.equals(this.missing, builder.missing) && Objects.equals(this.order, builder.order) && Objects.equals(this.sortMode, builder.sortMode) && Objects.equals(this.unmappedType, builder.unmappedType);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.nestedFilter, this.nestedPath, this.missing, this.order, this.sortMode, this.unmappedType);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static FieldSortBuilder fromXContent(QueryParseContext context, String fieldName) throws IOException {
        return PARSER.parse(context.parser(), new FieldSortBuilder(fieldName), context);
    }

    static {
        PARSER.declareField(FieldSortBuilder::missing, p -> p.objectText(), MISSING, ObjectParser.ValueType.VALUE);
        PARSER.declareString(FieldSortBuilder::setNestedPath, NESTED_PATH_FIELD);
        PARSER.declareString(FieldSortBuilder::unmappedType, UNMAPPED_TYPE);
        PARSER.declareString((b, v) -> {
            FieldSortBuilder cfr_ignored_0 = (FieldSortBuilder)b.order(SortOrder.fromString(v));
        }, ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORT_MODE);
        PARSER.declareObject(FieldSortBuilder::setNestedFilter, SortBuilder::parseNestedFilter, NESTED_FILTER_FIELD);
    }
}

