/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.tasks.TaskCancelledException;

public class CancellableCollector
extends FilterCollector {
    private final Provider<Boolean> cancelled;
    private final boolean leafLevel;

    public CancellableCollector(Provider<Boolean> cancelled, boolean lowLevelCancellation, Collector in) {
        super(in);
        this.cancelled = cancelled;
        this.leafLevel = lowLevelCancellation;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.cancelled.get().booleanValue()) {
            throw new TaskCancelledException("cancelled");
        }
        if (this.leafLevel) {
            return new CancellableLeafCollector(super.getLeafCollector(context));
        }
        return super.getLeafCollector(context);
    }

    private class CancellableLeafCollector
    extends FilterLeafCollector {
        private CancellableLeafCollector(LeafCollector in) {
            super(in);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (((Boolean)CancellableCollector.this.cancelled.get()).booleanValue()) {
                throw new TaskCancelledException("cancelled");
            }
            super.collect(doc);
        }
    }
}

