/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public enum MissingValues {


    public static ValuesSource.Bytes replaceMissing(final ValuesSource.Bytes valuesSource, final BytesRef missing) {
        return new ValuesSource.Bytes(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                SortedBinaryDocValues values = valuesSource.bytesValues(context);
                return MissingValues.replaceMissing(values, missing);
            }
        };
    }

    static SortedBinaryDocValues replaceMissing(final SortedBinaryDocValues values, final BytesRef missing) {
        return new SortedBinaryDocValues(){
            private int count;

            @Override
            public BytesRef valueAt(int index) {
                if (this.count > 0) {
                    return values.valueAt(index);
                }
                if (index == 0) {
                    return missing;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public void setDocument(int docId) {
                values.setDocument(docId);
                this.count = values.count();
            }

            @Override
            public int count() {
                return this.count == 0 ? 1 : this.count;
            }
        };
    }

    public static ValuesSource.Numeric replaceMissing(final ValuesSource.Numeric valuesSource, final Number missing) {
        boolean missingIsFloat = missing.doubleValue() % 1.0 != 0.0;
        final boolean isFloatingPoint = valuesSource.isFloatingPoint() || missingIsFloat;
        return new ValuesSource.Numeric(){

            @Override
            public boolean isFloatingPoint() {
                return isFloatingPoint;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing(valuesSource.bytesValues(context), new BytesRef(missing.toString()));
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                SortedNumericDocValues values = valuesSource.longValues(context);
                return MissingValues.replaceMissing(values, missing.longValue());
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                SortedNumericDoubleValues values = valuesSource.doubleValues(context);
                return MissingValues.replaceMissing(values, missing.doubleValue());
            }
        };
    }

    static SortedNumericDocValues replaceMissing(final SortedNumericDocValues values, final long missing) {
        return new SortedNumericDocValues(){
            private int count;

            @Override
            public void setDocument(int doc) {
                values.setDocument(doc);
                this.count = values.count();
            }

            @Override
            public long valueAt(int index) {
                if (this.count > 0) {
                    return values.valueAt(index);
                }
                if (index == 0) {
                    return missing;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int count() {
                return this.count == 0 ? 1 : this.count;
            }
        };
    }

    static SortedNumericDoubleValues replaceMissing(final SortedNumericDoubleValues values, final double missing) {
        return new SortedNumericDoubleValues(){
            private int count;

            @Override
            public void setDocument(int doc) {
                values.setDocument(doc);
                this.count = values.count();
            }

            @Override
            public double valueAt(int index) {
                if (this.count > 0) {
                    return values.valueAt(index);
                }
                if (index == 0) {
                    return missing;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int count() {
                return this.count == 0 ? 1 : this.count;
            }
        };
    }

    public static ValuesSource.Bytes replaceMissing(final ValuesSource.Bytes.WithOrdinals valuesSource, final BytesRef missing) {
        return new ValuesSource.Bytes.WithOrdinals(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                SortedBinaryDocValues values = valuesSource.bytesValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            @Override
            public RandomAccessOrds ordinalsValues(LeafReaderContext context) {
                RandomAccessOrds values = valuesSource.ordinalsValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            @Override
            public RandomAccessOrds globalOrdinalsValues(LeafReaderContext context) {
                RandomAccessOrds values = valuesSource.globalOrdinalsValues(context);
                return MissingValues.replaceMissing(values, missing);
            }
        };
    }

    static RandomAccessOrds replaceMissing(RandomAccessOrds values, BytesRef missing) {
        long missingOrd = values.lookupTerm(missing);
        if (missingOrd >= 0L) {
            return MissingValues.replaceMissingOrd(values, missingOrd);
        }
        long insertedOrd = -1L - missingOrd;
        return MissingValues.insertOrd(values, insertedOrd, missing);
    }

    static RandomAccessOrds replaceMissingOrd(final RandomAccessOrds values, final long missingOrd) {
        return new AbstractRandomAccessOrds(){
            private int cardinality = 0;

            @Override
            public void doSetDocument(int docID) {
                values.setDocument(docID);
                this.cardinality = values.cardinality();
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return values.lookupOrd(ord);
            }

            @Override
            public long getValueCount() {
                return values.getValueCount();
            }

            @Override
            public long ordAt(int index) {
                if (this.cardinality > 0) {
                    return values.ordAt(index);
                }
                if (index == 0) {
                    return missingOrd;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int cardinality() {
                return this.cardinality == 0 ? 1 : this.cardinality;
            }
        };
    }

    static RandomAccessOrds insertOrd(final RandomAccessOrds values, final long insertedOrd, final BytesRef missingValue) {
        return new AbstractRandomAccessOrds(){
            private int cardinality = 0;

            @Override
            public void doSetDocument(int docID) {
                values.setDocument(docID);
                this.cardinality = values.cardinality();
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                if (ord < insertedOrd) {
                    return values.lookupOrd(ord);
                }
                if (ord > insertedOrd) {
                    return values.lookupOrd(ord - 1L);
                }
                return missingValue;
            }

            @Override
            public long getValueCount() {
                return 1L + values.getValueCount();
            }

            @Override
            public long ordAt(int index) {
                if (this.cardinality > 0) {
                    long ord = values.ordAt(index);
                    if (ord < insertedOrd) {
                        return ord;
                    }
                    return ord + 1L;
                }
                if (index == 0) {
                    return insertedOrd;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int cardinality() {
                return this.cardinality == 0 ? 1 : this.cardinality;
            }
        };
    }

    public static ValuesSource.GeoPoint replaceMissing(final ValuesSource.GeoPoint valuesSource, final GeoPoint missing) {
        return new ValuesSource.GeoPoint(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing(valuesSource.bytesValues(context), new BytesRef(missing.toString()));
            }

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                MultiGeoPointValues values = valuesSource.geoPointValues(context);
                return MissingValues.replaceMissing(values, missing);
            }
        };
    }

    static MultiGeoPointValues replaceMissing(final MultiGeoPointValues values, final GeoPoint missing) {
        return new MultiGeoPointValues(){
            private int count;

            @Override
            public GeoPoint valueAt(int index) {
                if (this.count > 0) {
                    return values.valueAt(index);
                }
                if (index == 0) {
                    return missing;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public void setDocument(int docId) {
                values.setDocument(docId);
                this.count = values.count();
            }

            @Override
            public int count() {
                return this.count == 0 ? 1 : this.count;
            }
        };
    }
}

