/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.jackson;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.jackson.core.JsonParser;
import org.elasticsearch.jackson.core.JsonProcessingException;
import org.elasticsearch.jackson.core.type.TypeReference;
import org.elasticsearch.jackson.databind.DeserializationContext;
import org.elasticsearch.jackson.databind.deser.std.StdDeserializer;
import org.elasticsearch.log4j.core.jackson.MapEntry;

public class ListOfMapEntryDeserializer
extends StdDeserializer<Map<String, String>> {
    private static final long serialVersionUID = 1L;

    ListOfMapEntryDeserializer() {
        super(Map.class);
    }

    public Map<String, String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        List list = (List)jp.readValueAs(new TypeReference<List<MapEntry>>(){});
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (MapEntry mapEntry : list) {
            map.put(mapEntry.getKey(), mapEntry.getValue());
        }
        return map;
    }
}

