/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.jackson.core.JsonParser;
import org.elasticsearch.jackson.core.JsonProcessingException;
import org.elasticsearch.jackson.core.type.TypeReference;
import org.elasticsearch.jackson.databind.DeserializationContext;
import org.elasticsearch.jackson.databind.deser.std.StdDeserializer;
import org.elasticsearch.log4j.core.impl.ContextDataFactory;
import org.elasticsearch.log4j.core.jackson.MapEntry;
import org.elasticsearch.log4j.util.StringMap;

public class ContextDataAsEntryListDeserializer
extends StdDeserializer<StringMap> {
    private static final long serialVersionUID = 1L;

    ContextDataAsEntryListDeserializer() {
        super(Map.class);
    }

    public StringMap deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        List list = (List)jp.readValueAs(new TypeReference<List<MapEntry>>(){});
        new ContextDataFactory();
        StringMap contextData = ContextDataFactory.createContextData();
        for (MapEntry mapEntry : list) {
            contextData.putValue(mapEntry.getKey(), mapEntry.getValue());
        }
        return contextData;
    }
}

