/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jboss.netty.buffer;

import java.nio.ByteOrder;
import org.elasticsearch.jboss.netty.buffer.ChannelBuffer;
import org.elasticsearch.jboss.netty.buffer.ChannelBufferFactory;

public abstract class AbstractChannelBufferFactory
implements ChannelBufferFactory {
    private final ByteOrder defaultOrder;

    protected AbstractChannelBufferFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    protected AbstractChannelBufferFactory(ByteOrder defaultOrder) {
        if (defaultOrder == null) {
            throw new NullPointerException("defaultOrder");
        }
        this.defaultOrder = defaultOrder;
    }

    public ChannelBuffer getBuffer(int capacity) {
        return this.getBuffer(this.getDefaultOrder(), capacity);
    }

    public ChannelBuffer getBuffer(byte[] array, int offset, int length) {
        return this.getBuffer(this.getDefaultOrder(), array, offset, length);
    }

    public ByteOrder getDefaultOrder() {
        return this.defaultOrder;
    }
}

