/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jackson.dataformat.yaml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.jackson.core.Base64Variant;
import org.elasticsearch.jackson.core.FormatSchema;
import org.elasticsearch.jackson.core.JsonGenerationException;
import org.elasticsearch.jackson.core.JsonGenerator;
import org.elasticsearch.jackson.core.ObjectCodec;
import org.elasticsearch.jackson.core.PrettyPrinter;
import org.elasticsearch.jackson.core.SerializableString;
import org.elasticsearch.jackson.core.Version;
import org.elasticsearch.jackson.core.base.GeneratorBase;
import org.elasticsearch.jackson.core.io.IOContext;
import org.elasticsearch.jackson.dataformat.yaml.PackageVersion;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected static final Pattern PLAIN_NUMBER_P = Pattern.compile("[0-9]*(\\.[0-9]*)?");
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    private static final Character STYLE_NAME = null;
    private static final Character STYLE_SCALAR = null;
    private static final Character STYLE_QUOTED = Character.valueOf('\"');
    private static final Character STYLE_LITERAL = Character.valueOf('|');
    private static final Character STYLE_BASE64 = Character.valueOf('\"');
    private static final Character STYLE_PLAIN = null;
    protected Emitter _emitter;
    protected String _objectId;
    protected String _typeId;
    private static final ImplicitTuple DEFAULT_IMPLICIT = new ImplicitTuple(true, true);

    public YAMLGenerator(IOContext ctxt, int jsonFeatures, int yamlFeatures, ObjectCodec codec, Writer out, DumperOptions.Version version) throws IOException {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = yamlFeatures;
        this._writer = out;
        this._outputOptions = this.buildDumperOptions(jsonFeatures, yamlFeatures, version);
        this._emitter = new Emitter(this._writer, this._outputOptions);
        this._emitter.emit(new StreamStartEvent(null, null));
        Map<String, String> noTags = Collections.emptyMap();
        boolean startMarker = Feature.WRITE_DOC_START_MARKER.enabledIn(yamlFeatures);
        this._emitter.emit(new DocumentStartEvent(null, null, startMarker, version, noTags));
    }

    protected DumperOptions buildDumperOptions(int jsonFeatures, int yamlFeatures, DumperOptions.Version version) {
        DumperOptions opt = new DumperOptions();
        if (Feature.CANONICAL_OUTPUT.enabledIn(this._formatFeatures)) {
            opt.setCanonical(true);
        } else {
            opt.setCanonical(false);
            opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        }
        opt.setSplitLines(Feature.SPLIT_LINES.enabledIn(this._formatFeatures));
        return opt;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public YAMLGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        return -1;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    public YAMLGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public YAMLGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public YAMLGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    @Override
    public final void writeFieldName(String name) throws IOException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    @Override
    public final void writeFieldName(SerializableString name) throws IOException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name.getValue());
    }

    @Override
    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(fieldName);
        this.writeString(value);
    }

    private final void _writeFieldName(String name) throws IOException {
        this._writeScalar(name, "string", STYLE_NAME);
    }

    @Override
    public final void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this._emitter.emit(new DocumentEndEvent(null, null, false));
            this._emitter.emit(new StreamEndEvent(null, null));
            super.close();
            this._writer.close();
        }
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        Boolean style = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        this._emitter.emit(new SequenceStartEvent(anchor, yamlTag, implicit, null, null, style));
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new SequenceEndEvent(null, null));
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        Boolean style = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        this._emitter.emit(new MappingStartEvent(anchor, yamlTag, implicit, null, null, style));
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new MappingEndEvent(null, null));
    }

    @Override
    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        Character style = STYLE_QUOTED;
        if (Feature.MINIMIZE_QUOTES.enabledIn(this._formatFeatures) && !this.isBooleanContent(text)) {
            style = Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatFeatures) && PLAIN_NUMBER_P.matcher(text).matches() ? STYLE_QUOTED : (text.indexOf(10) >= 0 ? STYLE_LITERAL : STYLE_PLAIN);
        }
        this._writeScalar(text, "string", style);
    }

    private boolean isBooleanContent(String text) {
        return text.equals("true") || text.equals("false");
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    @Override
    public final void writeString(SerializableString sstr) throws IOException {
        this.writeString(sstr.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    @Override
    public void writeRaw(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeScalar(encoded, "byte[]", STYLE_BASE64);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(state ? "true" : "false", "bool", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(i), "int", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(long l) throws IOException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l), "long", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(v.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d), "double", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f), "float", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeScalar(str, "java.math.BigDecimal", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(encodedValue, "number", STYLE_SCALAR);
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    @Override
    public boolean canWriteObjectId() {
        return Feature.USE_NATIVE_OBJECT_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public boolean canWriteTypeId() {
        return Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public void writeTypeId(Object id) throws IOException {
        this._typeId = String.valueOf(id);
    }

    @Override
    public void writeObjectRef(Object id) throws IOException {
        this._verifyValueWrite("write Object reference");
        AliasEvent evt = new AliasEvent(String.valueOf(id), null, null);
        this._emitter.emit(evt);
    }

    @Override
    public void writeObjectId(Object id) throws IOException {
        this._objectId = String.valueOf(id);
    }

    @Override
    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    @Override
    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String value, String type, Character style) throws IOException {
        this._emitter.emit(this._scalarEvent(value, style));
    }

    protected ScalarEvent _scalarEvent(String value, Character style) {
        String anchor;
        String yamlTag = this._typeId;
        if (yamlTag != null) {
            this._typeId = null;
        }
        if ((anchor = this._objectId) != null) {
            this._objectId = null;
        }
        return new ScalarEvent(anchor, yamlTag, DEFAULT_IMPLICIT, value, null, null, style);
    }

    public static enum Feature {
        WRITE_DOC_START_MARKER(true),
        USE_NATIVE_OBJECT_ID(true),
        USE_NATIVE_TYPE_ID(true),
        CANONICAL_OUTPUT(false),
        SPLIT_LINES(true),
        MINIMIZE_QUOTES(false),
        ALWAYS_QUOTE_NUMBERS_AS_STRINGS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

