/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.io.netty.channel;

import org.elasticsearch.io.netty.channel.Channel;
import org.elasticsearch.io.netty.channel.ChannelFuture;
import org.elasticsearch.io.netty.channel.CompleteChannelFuture;
import org.elasticsearch.io.netty.util.concurrent.EventExecutor;
import org.elasticsearch.io.netty.util.internal.PlatformDependent;

final class FailedChannelFuture
extends CompleteChannelFuture {
    private final Throwable cause;

    FailedChannelFuture(Channel channel, EventExecutor executor, Throwable cause) {
        super(channel, executor);
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.cause = cause;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public ChannelFuture sync() {
        PlatformDependent.throwException(this.cause);
        return this;
    }

    @Override
    public ChannelFuture syncUninterruptibly() {
        PlatformDependent.throwException(this.cause);
        return this;
    }
}

