/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.io.netty.channel;

import org.elasticsearch.io.netty.channel.AbstractChannelHandlerContext;
import org.elasticsearch.io.netty.channel.ChannelHandler;
import org.elasticsearch.io.netty.channel.ChannelInboundHandler;
import org.elasticsearch.io.netty.channel.ChannelOutboundHandler;
import org.elasticsearch.io.netty.channel.DefaultChannelPipeline;
import org.elasticsearch.io.netty.util.concurrent.EventExecutor;

final class DefaultChannelHandlerContext
extends AbstractChannelHandlerContext {
    private final ChannelHandler handler;

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutor executor, String name, ChannelHandler handler) {
        super(pipeline, executor, name, DefaultChannelHandlerContext.isInbound(handler), DefaultChannelHandlerContext.isOutbound(handler));
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = handler;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    private static boolean isInbound(ChannelHandler handler) {
        return handler instanceof ChannelInboundHandler;
    }

    private static boolean isOutbound(ChannelHandler handler) {
        return handler instanceof ChannelOutboundHandler;
    }
}

