/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStoreConfig;
import org.elasticsearch.indices.AbstractIndexShardCacheEntity;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.IndicesRequestCache;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesService
extends AbstractLifecycleComponent
implements IndicesClusterStateService.AllocatedIndices<IndexShard, IndexService>,
IndexService.ShardStoreDeleter {
    public static final String INDICES_SHARDS_CLOSED_TIMEOUT = "indices.shards_closed_timeout";
    public static final Setting<TimeValue> INDICES_CACHE_CLEAN_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.cache.cleanup_interval", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    private final PluginsService pluginsService;
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry xContentRegistry;
    private final TimeValue shardsClosedTimeout;
    private final AnalysisRegistry analysisRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexScopedSettings indexScopeSetting;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final CacheCleaner cacheCleaner;
    private final ThreadPool threadPool;
    private final CircuitBreakerService circuitBreakerService;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final Client client;
    private volatile Map<String, IndexService> indices = Collections.emptyMap();
    private final Map<Index, List<PendingDelete>> pendingDeletes = new HashMap<Index, List<PendingDelete>>();
    private final AtomicInteger numUncompletedDeletes = new AtomicInteger();
    private final OldShardsStats oldShardsStats = new OldShardsStats();
    private final IndexStoreConfig indexStoreConfig;
    private final MapperRegistry mapperRegistry;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final IndexingMemoryController indexingMemoryController;
    private final TimeValue cleanInterval;
    private final IndicesRequestCache indicesRequestCache;
    private final IndicesQueryCache indicesQueryCache;
    private final MetaStateService metaStateService;
    private final IndexDeletionAllowedPredicate DEFAULT_INDEX_DELETION_PREDICATE = (index, indexSettings) -> this.canDeleteIndexContents(index, indexSettings);
    private final IndexDeletionAllowedPredicate ALWAYS_TRUE = (index, indexSettings) -> true;

    @Override
    protected void doStart() {
        this.threadPool.schedule(this.cleanInterval, "same", this.cacheCleaner);
    }

    public IndicesService(Settings settings, PluginsService pluginsService, NodeEnvironment nodeEnv, NamedXContentRegistry xContentRegistry, ClusterSettings clusterSettings, AnalysisRegistry analysisRegistry, IndexNameExpressionResolver indexNameExpressionResolver, MapperRegistry mapperRegistry, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadPool, IndexScopedSettings indexScopedSettings, final CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ScriptService scriptService, ClusterService clusterService, Client client, MetaStateService metaStateService) {
        super(settings);
        this.threadPool = threadPool;
        this.pluginsService = pluginsService;
        this.nodeEnv = nodeEnv;
        this.xContentRegistry = xContentRegistry;
        this.shardsClosedTimeout = settings.getAsTime(INDICES_SHARDS_CLOSED_TIMEOUT, new TimeValue(1L, TimeUnit.DAYS));
        this.indexStoreConfig = new IndexStoreConfig(settings);
        this.analysisRegistry = analysisRegistry;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesRequestCache = new IndicesRequestCache(settings);
        this.indicesQueryCache = new IndicesQueryCache(settings);
        this.mapperRegistry = mapperRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        clusterSettings.addSettingsUpdateConsumer(IndexStoreConfig.INDICES_STORE_THROTTLE_TYPE_SETTING, this.indexStoreConfig::setRateLimitingType);
        clusterSettings.addSettingsUpdateConsumer(IndexStoreConfig.INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC_SETTING, this.indexStoreConfig::setRateLimitingThrottle);
        this.indexingMemoryController = new IndexingMemoryController(settings, threadPool, () -> Iterables.flatten(this).iterator());
        this.indexScopeSetting = indexScopedSettings;
        this.circuitBreakerService = circuitBreakerService;
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
        this.indicesFieldDataCache = new IndicesFieldDataCache(settings, new IndexFieldDataCache.Listener(){

            @Override
            public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
                assert (sizeInBytes >= 0L) : "When reducing circuit breaker, it should be adjusted with a number higher or equal to 0 and not [" + sizeInBytes + "]";
                circuitBreakerService.getBreaker("fielddata").addWithoutBreaking(-sizeInBytes);
            }
        });
        this.cleanInterval = INDICES_CACHE_CLEAN_INTERVAL_SETTING.get(settings);
        this.cacheCleaner = new CacheCleaner(this.indicesFieldDataCache, this.indicesRequestCache, this.logger, threadPool, this.cleanInterval);
        this.metaStateService = metaStateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory("indices_shutdown"));
        Set indices = this.indices.values().stream().map(s -> s.index()).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(indices.size());
        for (Index index : indices) {
            indicesStopExecutor.execute(() -> {
                try {
                    this.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "shutdown");
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(this.shardsClosedTimeout.seconds(), TimeUnit.SECONDS)) {
                this.logger.warn("Not all shards are closed yet, waited {}sec - stopping service", (Object)this.shardsClosedTimeout.seconds());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            indicesStopExecutor.shutdown();
        }
    }

    @Override
    protected void doClose() {
        IOUtils.closeWhileHandlingException(this.analysisRegistry, this.indexingMemoryController, this.indicesFieldDataCache, this.cacheCleaner, this.indicesRequestCache, this.indicesQueryCache);
    }

    public NodeIndicesStats stats(boolean includePrevious) {
        return this.stats(includePrevious, new CommonStatsFlags(new CommonStatsFlags.Flag[0]).all());
    }

    public NodeIndicesStats stats(boolean includePrevious, CommonStatsFlags flags) {
        CommonStats oldStats = new CommonStats(flags);
        if (includePrevious) {
            CommonStatsFlags.Flag[] setFlags = flags.getFlags();
            block11: for (CommonStatsFlags.Flag flag : setFlags) {
                switch (flag) {
                    case Get: {
                        oldStats.get.add(this.oldShardsStats.getStats);
                        continue block11;
                    }
                    case Indexing: {
                        oldStats.indexing.add(this.oldShardsStats.indexingStats);
                        continue block11;
                    }
                    case Search: {
                        oldStats.search.add(this.oldShardsStats.searchStats);
                        continue block11;
                    }
                    case Merge: {
                        oldStats.merge.add(this.oldShardsStats.mergeStats);
                        continue block11;
                    }
                    case Refresh: {
                        oldStats.refresh.add(this.oldShardsStats.refreshStats);
                        continue block11;
                    }
                    case Recovery: {
                        oldStats.recoveryStats.add(this.oldShardsStats.recoveryStats);
                        continue block11;
                    }
                    case Flush: {
                        oldStats.flush.add(this.oldShardsStats.flushStats);
                    }
                }
            }
        }
        HashMap<Index, List<IndexShardStats>> statsByShard = new HashMap<Index, List<IndexShardStats>>();
        for (IndexService indexService : this) {
            for (IndexShard indexShard : indexService) {
                try {
                    if (indexShard.routingEntry() == null) continue;
                    IndexShardStats indexShardStats = new IndexShardStats(indexShard.shardId(), new ShardStats[]{new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(this.indicesQueryCache, indexShard, flags), indexShard.commitStats())});
                    if (!statsByShard.containsKey(indexService.index())) {
                        statsByShard.put(indexService.index(), CollectionUtils.arrayAsArrayList(indexShardStats));
                        continue;
                    }
                    ((List)statsByShard.get(indexService.index())).add(indexShardStats);
                }
                catch (IllegalIndexShardStateException e) {
                    this.logger.trace(() -> new ParameterizedMessage("{} ignoring shard stats", (Object)indexShard.shardId()), (Throwable)e);
                }
            }
        }
        return new NodeIndicesStats(oldStats, statsByShard);
    }

    private void ensureChangesAllowed() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("Can't make changes to indices service, node is closed");
        }
    }

    @Override
    public Iterator<IndexService> iterator() {
        return this.indices.values().iterator();
    }

    public boolean hasIndex(Index index) {
        return this.indices.containsKey(index.getUUID());
    }

    @Override
    @Nullable
    public IndexService indexService(Index index) {
        return this.indices.get(index.getUUID());
    }

    public IndexService indexServiceSafe(Index index) {
        IndexService indexService = this.indices.get(index.getUUID());
        if (indexService == null) {
            throw new IndexNotFoundException(index);
        }
        assert (indexService.indexUUID().equals(index.getUUID())) : "uuid mismatch local: " + indexService.indexUUID() + " incoming: " + index.getUUID();
        return indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IndexService createIndex(IndexMetaData indexMetaData, List<IndexEventListener> builtInListeners) throws IOException {
        this.ensureChangesAllowed();
        if (indexMetaData.getIndexUUID().equals("_na_")) {
            throw new IllegalArgumentException("index must have a real UUID found value: [" + indexMetaData.getIndexUUID() + "]");
        }
        Index index = indexMetaData.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        ArrayList<IndexEventListener> finalListeners = new ArrayList<IndexEventListener>(builtInListeners);
        IndexEventListener onStoreClose = new IndexEventListener(){

            @Override
            public void onStoreClosed(ShardId shardId) {
                IndicesService.this.indicesQueryCache.onClose(shardId);
            }
        };
        finalListeners.add(onStoreClose);
        finalListeners.add(this.oldShardsStats);
        IndexService indexService = this.createIndexService("create index", indexMetaData, this.indicesQueryCache, this.indicesFieldDataCache, finalListeners, this.indexingMemoryController);
        boolean success = false;
        try {
            indexService.getIndexEventListener().afterIndexCreated(indexService);
            this.indices = MapBuilder.newMapBuilder(this.indices).put(index.getUUID(), indexService).immutableMap();
            success = true;
            IndexService indexService2 = indexService;
            return indexService2;
        }
        finally {
            if (!success) {
                indexService.close("plugins_failed", true);
            }
        }
    }

    private synchronized IndexService createIndexService(String reason, IndexMetaData indexMetaData, IndicesQueryCache indicesQueryCache, IndicesFieldDataCache indicesFieldDataCache, List<IndexEventListener> builtInListeners, IndexingOperationListener ... indexingOperationListeners) throws IOException {
        Index index = indexMetaData.getIndex();
        Predicate<String> indexNameMatcher = indexExpression -> this.indexNameExpressionResolver.matchesIndex(index.getName(), (String)indexExpression, this.clusterService.state());
        IndexSettings idxSettings = new IndexSettings(indexMetaData, this.settings, indexNameMatcher, this.indexScopeSetting);
        this.logger.debug("creating Index [{}], shards [{}]/[{}{}] - reason [{}]", (Object)indexMetaData.getIndex(), (Object)idxSettings.getNumberOfShards(), (Object)idxSettings.getNumberOfReplicas(), (Object)(idxSettings.isShadowReplicaIndex() ? "s" : ""), (Object)reason);
        IndexModule indexModule = new IndexModule(idxSettings, this.indexStoreConfig, this.analysisRegistry);
        for (IndexingOperationListener operationListener : indexingOperationListeners) {
            indexModule.addIndexOperationListener(operationListener);
        }
        this.pluginsService.onIndexModule(indexModule);
        for (IndexEventListener listener : builtInListeners) {
            indexModule.addIndexEventListener(listener);
        }
        return indexModule.newIndexService(this.nodeEnv, this.xContentRegistry, this, this.circuitBreakerService, this.bigArrays, this.threadPool, this.scriptService, this.clusterService, this.client, indicesQueryCache, this.mapperRegistry, indicesFieldDataCache);
    }

    public synchronized MapperService createIndexMapperService(IndexMetaData indexMetaData) throws IOException {
        Index index = indexMetaData.getIndex();
        Predicate<String> indexNameMatcher = indexExpression -> this.indexNameExpressionResolver.matchesIndex(index.getName(), (String)indexExpression, this.clusterService.state());
        IndexSettings idxSettings = new IndexSettings(indexMetaData, this.settings, indexNameMatcher, this.indexScopeSetting);
        IndexModule indexModule = new IndexModule(idxSettings, this.indexStoreConfig, this.analysisRegistry);
        this.pluginsService.onIndexModule(indexModule);
        return indexModule.newIndexMapperService(this.xContentRegistry, this.mapperRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyIndexMetadata(IndexMetaData metaData, IndexMetaData metaDataUpdate) throws IOException {
        ArrayList<Object> closeables = new ArrayList<Object>();
        try {
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(this.settings, new IndexFieldDataCache.Listener(){});
            closeables.add(indicesFieldDataCache);
            IndicesQueryCache indicesQueryCache = new IndicesQueryCache(this.settings);
            closeables.add(indicesQueryCache);
            IndexService service = this.createIndexService("metadata verification", metaData, indicesQueryCache, indicesFieldDataCache, Collections.emptyList(), new IndexingOperationListener[0]);
            closeables.add(() -> service.close("metadata verification", false));
            service.mapperService().merge(metaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            if (!metaData.equals(metaDataUpdate)) {
                service.updateMetaData(metaDataUpdate);
            }
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    @Override
    public IndexShard createShard(ShardRouting shardRouting, RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, Callback<IndexShard.ShardFailure> onShardFailure) throws IOException {
        this.ensureChangesAllowed();
        IndexService indexService = this.indexService(shardRouting.index());
        IndexShard indexShard = indexService.createShard(shardRouting);
        indexShard.addShardFailureCallback(onShardFailure);
        indexShard.startRecovery(recoveryState, recoveryTargetService, recoveryListener, repositoriesService, (type, mapping) -> {
            assert (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "mapping update consumer only required by local shards recovery";
            try {
                this.client.admin().indices().preparePutMapping(new String[0]).setConcreteIndex(shardRouting.index()).setType((String)type).setSource(mapping.source().string()).get();
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to stringify mapping source", (Throwable)ex, new Object[0]);
            }
        }, this);
        return indexShard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason, String extraInfo) {
        String indexName = index.getName();
        try {
            IndexEventListener listener;
            IndexService indexService;
            IndicesService indicesService = this;
            synchronized (indicesService) {
                if (!this.hasIndex(index)) {
                    return;
                }
                this.logger.debug("[{}] closing ... (reason [{}])", (Object)indexName, (Object)reason);
                HashMap<String, IndexService> newIndices = new HashMap<String, IndexService>(this.indices);
                indexService = (IndexService)newIndices.remove(index.getUUID());
                assert (indexService != null) : "IndexService is null for index: " + index;
                this.indices = Collections.unmodifiableMap(newIndices);
                listener = indexService.getIndexEventListener();
            }
            listener.beforeIndexRemoved(indexService, reason);
            this.logger.debug("{} closing index service (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            indexService.close(extraInfo, reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED);
            this.logger.debug("{} closed... (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            IndexSettings indexSettings = indexService.getIndexSettings();
            listener.afterIndexRemoved(indexService.index(), indexSettings, reason);
            if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED) {
                this.deleteIndexStore(extraInfo, indexService.index(), indexSettings);
            }
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("failed to remove index {} ([{}][{}])", new Object[]{index, reason, extraInfo}), (Throwable)e);
        }
    }

    public IndicesFieldDataCache getIndicesFieldDataCache() {
        return this.indicesFieldDataCache;
    }

    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public IndicesQueryCache getIndicesQueryCache() {
        return this.indicesQueryCache;
    }

    @Override
    public void deleteUnassignedIndex(String reason, IndexMetaData metaData, ClusterState clusterState) {
        if (this.nodeEnv.hasNodeFile()) {
            String indexName = metaData.getIndex().getName();
            try {
                if (clusterState.metaData().hasIndex(indexName)) {
                    IndexMetaData index = clusterState.metaData().index(indexName);
                    throw new IllegalStateException("Can't delete unassigned index store for [" + indexName + "] - it's still part of the cluster state [" + index.getIndexUUID() + "] [" + metaData.getIndexUUID() + "]");
                }
                this.deleteIndexStore(reason, metaData, clusterState);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to delete unassigned index (reason [{}])", (Object)metaData.getIndex(), (Object)reason), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndexStore(String reason, IndexMetaData metaData, ClusterState clusterState) throws IOException {
        if (this.nodeEnv.hasNodeFile()) {
            IndicesService indicesService = this;
            synchronized (indicesService) {
                Index index = metaData.getIndex();
                if (this.hasIndex(index)) {
                    String localUUid = this.indexService(index).indexUUID();
                    throw new IllegalStateException("Can't delete index store for [" + index.getName() + "] - it's still part of the indices service [" + localUUid + "] [" + metaData.getIndexUUID() + "]");
                }
                if (clusterState.metaData().hasIndex(index.getName()) && clusterState.nodes().getLocalNode().isMasterNode()) {
                    IndexMetaData idxMeta = clusterState.metaData().index(index.getName());
                    throw new IllegalStateException("Can't delete index store for [" + index.getName() + "] - it's still part of the cluster state [" + idxMeta.getIndexUUID() + "] [" + metaData.getIndexUUID() + "], we are master eligible, so will keep the index metadata even if no shards are left.");
                }
            }
            IndexSettings indexSettings = this.buildIndexSettings(metaData);
            this.deleteIndexStore(reason, indexSettings.getIndex(), indexSettings);
        }
    }

    private void deleteIndexStore(String reason, Index index, IndexSettings indexSettings) throws IOException {
        this.deleteIndexStoreIfDeletionAllowed(reason, index, indexSettings, this.DEFAULT_INDEX_DELETION_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexStoreIfDeletionAllowed(String reason, Index index, IndexSettings indexSettings, IndexDeletionAllowedPredicate predicate) throws IOException {
        boolean success = false;
        try {
            this.logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)reason);
            if (predicate.apply(index, indexSettings)) {
                this.nodeEnv.deleteIndexDirectorySafe(index, 0L, indexSettings);
            }
            success = true;
        }
        catch (LockObtainFailedException ex) {
            this.logger.debug(() -> new ParameterizedMessage("{} failed to delete index store - at least one shards is still locked", (Object)index), (Throwable)ex);
        }
        catch (Exception ex) {
            this.logger.warn(() -> new ParameterizedMessage("{} failed to delete index", (Object)index), (Throwable)ex);
        }
        finally {
            if (!success) {
                this.addPendingDelete(index, indexSettings);
            }
            MetaDataStateFormat.deleteMetaState(this.nodeEnv.indexPaths(index));
        }
    }

    @Override
    public void deleteShardStore(String reason, ShardLock lock, IndexSettings indexSettings) throws IOException {
        ShardId shardId = lock.getShardId();
        this.logger.trace("{} deleting shard reason [{}]", (Object)shardId, (Object)reason);
        this.nodeEnv.deleteShardDirectoryUnderLock(lock, indexSettings);
    }

    public void deleteShardStore(String reason, ShardId shardId, ClusterState clusterState) throws IOException, ShardLockObtainFailedException {
        IndexMetaData metaData = clusterState.getMetaData().indices().get(shardId.getIndexName());
        IndexSettings indexSettings = this.buildIndexSettings(metaData);
        ShardDeletionCheckResult shardDeletionCheckResult = this.canDeleteShardContent(shardId, indexSettings);
        if (shardDeletionCheckResult != ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE) {
            throw new IllegalStateException("Can't delete shard " + shardId + " (cause: " + (Object)((Object)shardDeletionCheckResult) + ")");
        }
        this.nodeEnv.deleteShardDirectorySafe(shardId, indexSettings);
        this.logger.debug("{} deleted shard reason [{}]", (Object)shardId, (Object)reason);
        if (!clusterState.nodes().getLocalNode().isMasterNode() && this.canDeleteIndexContents(shardId.getIndex(), indexSettings)) {
            if (this.nodeEnv.findAllShardIds(shardId.getIndex()).isEmpty()) {
                try {
                    this.deleteIndexStore("no longer used", metaData, clusterState);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to delete unused index after deleting its last shard (" + shardId + ")", (Throwable)e, new Object[0]);
                }
            } else {
                this.logger.trace("[{}] still has shard stores, leaving as is", (Object)shardId.getIndex());
            }
        }
    }

    public boolean canDeleteIndexContents(Index index, IndexSettings indexSettings) {
        if (!indexSettings.isOnSharedFilesystem() || indexSettings.getIndexMetaData().getState() == IndexMetaData.State.CLOSE) {
            IndexService indexService = this.indexService(index);
            if (indexService == null && this.nodeEnv.hasNodeFile()) {
                return true;
            }
        } else {
            this.logger.trace("{} skipping index directory deletion due to shadow replicas", (Object)index);
        }
        return false;
    }

    @Override
    @Nullable
    public IndexMetaData verifyIndexIsDeleted(Index index, ClusterState clusterState) {
        if (clusterState.metaData().index(index) != null) {
            throw new IllegalStateException("Cannot delete index [" + index + "], it is still part of the cluster state.");
        }
        if (this.nodeEnv.hasNodeFile() && FileSystemUtils.exists(this.nodeEnv.indexPaths(index))) {
            IndexMetaData metaData;
            try {
                metaData = this.metaStateService.loadIndexState(index);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to load state file from a stale deleted index, folders will be left on disk", (Object)index), (Throwable)e);
                return null;
            }
            IndexSettings indexSettings = this.buildIndexSettings(metaData);
            try {
                this.deleteIndexStoreIfDeletionAllowed("stale deleted index", index, indexSettings, this.ALWAYS_TRUE);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to delete index on disk", (Object)metaData.getIndex()), (Throwable)e);
            }
            return metaData;
        }
        return null;
    }

    public ShardDeletionCheckResult canDeleteShardContent(ShardId shardId, IndexSettings indexSettings) {
        assert (shardId.getIndex().equals(indexSettings.getIndex()));
        IndexService indexService = this.indexService(shardId.getIndex());
        if (!indexSettings.isOnSharedFilesystem()) {
            if (this.nodeEnv.hasNodeFile()) {
                boolean isAllocated;
                boolean bl = isAllocated = indexService != null && indexService.hasShard(shardId.id());
                if (isAllocated) {
                    return ShardDeletionCheckResult.STILL_ALLOCATED;
                }
                if (indexSettings.hasCustomDataPath()) {
                    return Files.exists(this.nodeEnv.resolveCustomLocation(indexSettings, shardId), new LinkOption[0]) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
                }
                return FileSystemUtils.exists(this.nodeEnv.availableShardPaths(shardId)) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
            }
            return ShardDeletionCheckResult.NO_LOCAL_STORAGE;
        }
        this.logger.trace("{} skipping shard directory deletion due to shadow replicas", (Object)shardId);
        return ShardDeletionCheckResult.SHARED_FILE_SYSTEM;
    }

    private IndexSettings buildIndexSettings(IndexMetaData metaData) {
        return new IndexSettings(metaData, this.settings);
    }

    @Override
    public void addPendingDelete(ShardId shardId, IndexSettings settings) {
        if (shardId == null) {
            throw new IllegalArgumentException("shardId must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        PendingDelete pendingDelete = new PendingDelete(shardId, settings);
        this.addPendingDelete(shardId.getIndex(), pendingDelete);
    }

    public void addPendingDelete(Index index, IndexSettings settings) {
        PendingDelete pendingDelete = new PendingDelete(index, settings);
        this.addPendingDelete(index, pendingDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingDelete(Index index, PendingDelete pendingDelete) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> list = this.pendingDeletes.get(index);
            if (list == null) {
                list = new ArrayList<PendingDelete>();
                this.pendingDeletes.put(index, list);
            }
            list.add(pendingDelete);
            this.numUncompletedDeletes.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPendingDeletes(Index index, IndexSettings indexSettings, TimeValue timeout) throws IOException, InterruptedException, ShardLockObtainFailedException {
        block20: {
            this.logger.debug("{} processing pending deletes", (Object)index);
            long startTimeNS = System.nanoTime();
            List<ShardLock> shardLocks = this.nodeEnv.lockAllForIndex(index, indexSettings, timeout.millis());
            int numRemoved = 0;
            try {
                List<PendingDelete> remove;
                HashMap<ShardId, ShardLock> locks = new HashMap<ShardId, ShardLock>();
                for (ShardLock shardLock : shardLocks) {
                    locks.put(shardLock.getShardId(), shardLock);
                }
                Map<Index, List<PendingDelete>> map = this.pendingDeletes;
                synchronized (map) {
                    remove = this.pendingDeletes.remove(index);
                }
                if (remove == null || remove.isEmpty()) break block20;
                numRemoved = remove.size();
                CollectionUtil.timSort(remove);
                long l = 10000L;
                long sleepTime = 10L;
                do {
                    if (remove.isEmpty()) {
                        break;
                    }
                    Iterator<PendingDelete> iterator = remove.iterator();
                    while (iterator.hasNext()) {
                        PendingDelete delete = iterator.next();
                        if (delete.deleteIndex) {
                            assert (delete.shardId == -1);
                            this.logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)"pending delete");
                            try {
                                this.nodeEnv.deleteIndexDirectoryUnderLock(index, indexSettings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                this.logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)index), (Throwable)ex);
                            }
                            continue;
                        }
                        assert (delete.shardId != -1);
                        ShardLock shardLock = (ShardLock)locks.get(new ShardId(delete.index, delete.shardId));
                        if (shardLock != null) {
                            try {
                                this.deleteShardStore("pending delete", shardLock, delete.settings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                this.logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)shardLock.getShardId()), (Throwable)ex);
                            }
                            continue;
                        }
                        this.logger.warn("{} no shard lock for pending delete", (Object)delete.shardId);
                        iterator.remove();
                    }
                    if (remove.isEmpty()) continue;
                    this.logger.warn("{} still pending deletes present for shards {} - retrying", (Object)index, (Object)remove.toString());
                    Thread.sleep(sleepTime);
                    sleepTime = Math.min(10000L, sleepTime * 2L);
                    this.logger.debug("{} schedule pending delete retry after {} ms", (Object)index, (Object)sleepTime);
                } while (System.nanoTime() - startTimeNS < timeout.nanos());
            }
            finally {
                IOUtils.close(shardLocks);
                if (numRemoved > 0) {
                    int remainingUncompletedDeletes = this.numUncompletedDeletes.addAndGet(-numRemoved);
                    assert (remainingUncompletedDeletes >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPendingDeletes(Index index) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> deleteList = this.pendingDeletes.get(index);
            if (deleteList == null) {
                return 0;
            }
            return deleteList.size();
        }
    }

    public boolean hasUncompletedPendingDeletes() {
        return this.numUncompletedDeletes.get() > 0;
    }

    public AnalysisRegistry getAnalysis() {
        return this.analysisRegistry;
    }

    public boolean canCache(ShardSearchRequest request, SearchContext context) {
        if (SearchType.QUERY_THEN_FETCH != context.searchType()) {
            return false;
        }
        IndexSettings settings = context.indexShard().indexSettings();
        if (request.requestCache() == null) {
            if (!settings.getValue(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING).booleanValue()) {
                return false;
            }
            if (context.size() != 0) {
                return false;
            }
        } else if (!request.requestCache().booleanValue()) {
            return false;
        }
        if (!(context.searcher().getIndexReader() instanceof DirectoryReader)) {
            return false;
        }
        return context.getQueryShardContext().isCachable();
    }

    public void clearRequestCache(IndexShard shard) {
        if (shard == null) {
            return;
        }
        this.indicesRequestCache.clear(new IndexShardCacheEntity(shard));
        this.logger.trace("{} explicit cache clear", (Object)shard.shardId());
    }

    public void loadIntoContext(ShardSearchRequest request, SearchContext context, QueryPhase queryPhase) throws Exception {
        assert (this.canCache(request, context));
        DirectoryReader directoryReader = context.searcher().getDirectoryReader();
        boolean[] loadedFromCache = new boolean[]{true};
        BytesReference bytesReference = this.cacheShardLevelResult(context.indexShard(), directoryReader, request.cacheKey(), out -> {
            queryPhase.execute(context);
            try {
                context.queryResult().writeToNoId((StreamOutput)out);
            }
            catch (IOException e) {
                throw new AssertionError("Could not serialize response", e);
            }
            loadedFromCache[0] = false;
        });
        if (loadedFromCache[0]) {
            QuerySearchResult result = context.queryResult();
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(bytesReference.streamInput(), this.namedWriteableRegistry);
            result.readFromWithId(context.id(), in);
            result.shardTarget(context.shardTarget());
        } else if (context.queryResult().searchTimedOut()) {
            this.indicesRequestCache.invalidate(new IndexShardCacheEntity(context.indexShard()), directoryReader, request.cacheKey());
        }
    }

    public FieldStats<?> getFieldStats(IndexShard shard, Engine.Searcher searcher, String field, boolean useCache) throws Exception {
        MappedFieldType fieldType = shard.mapperService().fullName(field);
        if (fieldType == null) {
            return null;
        }
        if (!useCache) {
            return fieldType.stats(searcher.reader());
        }
        BytesArray cacheKey = new BytesArray("fieldstats:" + field);
        BytesReference statsRef = this.cacheShardLevelResult(shard, searcher.getDirectoryReader(), cacheKey, out -> {
            try {
                out.writeOptionalWriteable(fieldType.stats(searcher.reader()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write field stats output", e);
            }
        });
        try (StreamInput in = statsRef.streamInput();){
            FieldStats fieldStats = in.readOptionalWriteable(FieldStats::readFrom);
            return fieldStats;
        }
    }

    public ByteSizeValue getTotalIndexingBufferBytes() {
        return this.indexingMemoryController.indexingBufferSize();
    }

    private BytesReference cacheShardLevelResult(IndexShard shard, DirectoryReader reader, BytesReference cacheKey, Consumer<StreamOutput> loader) throws Exception {
        IndexShardCacheEntity cacheEntity = new IndexShardCacheEntity(shard);
        Supplier<BytesReference> supplier = () -> {
            int expectedSizeInBytes = 512;
            try (BytesStreamOutput out = new BytesStreamOutput(512);){
                loader.accept(out);
                BytesReference bytesReference = out.bytes();
                return bytesReference;
            }
        };
        return this.indicesRequestCache.getOrCompute(cacheEntity, supplier, reader, cacheKey);
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, String ... expressions) {
        CheckedFunction<byte[], Optional<QueryBuilder>, IOException> filterParser = bytes -> {
            try (XContentParser parser = XContentFactory.xContent(bytes).createParser(this.xContentRegistry, (byte[])bytes);){
                Optional<QueryBuilder> optional = new QueryParseContext(parser).parseInnerQueryBuilder();
                return optional;
            }
        };
        String[] aliases = this.indexNameExpressionResolver.filteringAliases(state, index, expressions);
        IndexMetaData indexMetaData = state.metaData().index(index);
        return new AliasFilter(ShardSearchRequest.parseAliasFilter(filterParser, indexMetaData, aliases), aliases);
    }

    @FunctionalInterface
    static interface IndexDeletionAllowedPredicate {
        public boolean apply(Index var1, IndexSettings var2);
    }

    static final class IndexShardCacheEntity
    extends AbstractIndexShardCacheEntity {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IndexShardCacheEntity.class);
        private final IndexShard indexShard;

        protected IndexShardCacheEntity(IndexShard indexShard) {
            this.indexShard = indexShard;
        }

        @Override
        protected ShardRequestCache stats() {
            return this.indexShard.requestCache();
        }

        @Override
        public boolean isOpen() {
            return this.indexShard.state() != IndexShardState.CLOSED;
        }

        @Override
        public Object getCacheIdentity() {
            return this.indexShard;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }
    }

    private static final class CacheCleaner
    implements Runnable,
    Releasable {
        private final IndicesFieldDataCache cache;
        private final Logger logger;
        private final ThreadPool threadPool;
        private final TimeValue interval;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final IndicesRequestCache requestCache;

        CacheCleaner(IndicesFieldDataCache cache, IndicesRequestCache requestCache, Logger logger, ThreadPool threadPool, TimeValue interval) {
            this.cache = cache;
            this.requestCache = requestCache;
            this.logger = logger;
            this.threadPool = threadPool;
            this.interval = interval;
        }

        @Override
        public void run() {
            long startTimeNS = System.nanoTime();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("running periodic field data cache cleanup");
            }
            try {
                this.cache.getCache().refresh();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic field data cache cleanup:", (Throwable)e);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("periodic field data cache cleanup finished in {} milliseconds", (Object)TimeValue.nsecToMSec(System.nanoTime() - startTimeNS));
            }
            try {
                this.requestCache.cleanCache();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic request cache cleanup:", (Throwable)e);
            }
            if (!this.closed.get()) {
                this.threadPool.schedule(this.interval, "same", this);
            }
        }

        @Override
        public void close() {
            this.closed.compareAndSet(false, true);
        }
    }

    private static final class PendingDelete
    implements Comparable<PendingDelete> {
        final Index index;
        final int shardId;
        final IndexSettings settings;
        final boolean deleteIndex;

        PendingDelete(ShardId shardId, IndexSettings settings) {
            this.index = shardId.getIndex();
            this.shardId = shardId.getId();
            this.settings = settings;
            this.deleteIndex = false;
        }

        PendingDelete(Index index, IndexSettings settings) {
            this.index = index;
            this.shardId = -1;
            this.settings = settings;
            this.deleteIndex = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.index).append("]");
            if (this.shardId != -1) {
                sb.append("[").append(this.shardId).append("]");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PendingDelete o) {
            return Integer.compare(this.shardId, o.shardId);
        }
    }

    public static enum ShardDeletionCheckResult {
        FOLDER_FOUND_CAN_DELETE,
        STILL_ALLOCATED,
        NO_FOLDER_FOUND,
        SHARED_FILE_SYSTEM,
        NO_LOCAL_STORAGE;

    }

    static class OldShardsStats
    implements IndexEventListener {
        final SearchStats searchStats = new SearchStats();
        final GetStats getStats = new GetStats();
        final IndexingStats indexingStats = new IndexingStats();
        final MergeStats mergeStats = new MergeStats();
        final RefreshStats refreshStats = new RefreshStats();
        final FlushStats flushStats = new FlushStats();
        final RecoveryStats recoveryStats = new RecoveryStats();

        OldShardsStats() {
        }

        @Override
        public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            if (indexShard != null) {
                this.getStats.addTotals(indexShard.getStats());
                this.indexingStats.addTotals(indexShard.indexingStats(new String[0]));
                this.searchStats.addTotals(indexShard.searchStats(new String[0]));
                this.mergeStats.addTotals(indexShard.mergeStats());
                this.refreshStats.addTotals(indexShard.refreshStats());
                this.flushStats.addTotals(indexShard.flushStats());
                this.recoveryStats.addTotals(indexShard.recoveryStats());
            }
        }
    }
}

