/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.similarities.DFISimilarity;
import org.apache.lucene.search.similarities.Independence;
import org.apache.lucene.search.similarities.IndependenceChiSquared;
import org.apache.lucene.search.similarities.IndependenceSaturated;
import org.apache.lucene.search.similarities.IndependenceStandardized;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.AbstractSimilarityProvider;

public class DFISimilarityProvider
extends AbstractSimilarityProvider {
    private static final Map<String, Independence> INDEPENDENCE_MEASURES;
    private final DFISimilarity similarity;

    public DFISimilarityProvider(String name, Settings settings) {
        super(name);
        boolean discountOverlaps = settings.getAsBoolean("discount_overlaps", true);
        Independence measure = this.parseIndependence(settings);
        this.similarity = new DFISimilarity(measure);
        this.similarity.setDiscountOverlaps(discountOverlaps);
    }

    private Independence parseIndependence(Settings settings) {
        String name = settings.get("independence_measure");
        Independence measure = INDEPENDENCE_MEASURES.get(name);
        if (measure == null) {
            throw new IllegalArgumentException("Unsupported IndependenceMeasure [" + name + "]");
        }
        return measure;
    }

    @Override
    public Similarity get() {
        return this.similarity;
    }

    static {
        HashMap<String, Independence> measures = new HashMap<String, Independence>();
        measures.put("standardized", new IndependenceStandardized());
        measures.put("saturated", new IndependenceSaturated());
        measures.put("chisquared", new IndependenceChiSquared());
        INDEPENDENCE_MEASURES = Collections.unmodifiableMap(measures);
    }
}

