/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.log4j.Logger;

public abstract class AbstractIndexShardComponent
implements IndexShardComponent {
    protected final Logger logger;
    protected final DeprecationLogger deprecationLogger;
    protected final ShardId shardId;
    protected final IndexSettings indexSettings;

    protected AbstractIndexShardComponent(ShardId shardId, IndexSettings indexSettings) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.logger = Loggers.getLogger(this.getClass(), this.indexSettings.getSettings(), shardId, new String[0]);
        this.deprecationLogger = new DeprecationLogger(this.logger);
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public String nodeName() {
        return this.indexSettings.getNodeName();
    }
}

