/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.RethrottleAction;
import org.elasticsearch.index.reindex.RethrottleRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.admin.cluster.RestListTasksAction;
import org.elasticsearch.tasks.TaskId;

public class RestRethrottleAction
extends BaseRestHandler {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestRethrottleAction(Settings settings, RestController controller, Supplier<DiscoveryNodes> nodesInCluster) {
        super(settings);
        this.nodesInCluster = nodesInCluster;
        controller.registerHandler(RestRequest.Method.POST, "/_update_by_query/{taskId}/_rethrottle", this);
        controller.registerHandler(RestRequest.Method.POST, "/_delete_by_query/{taskId}/_rethrottle", this);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex/{taskId}/_rethrottle", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RethrottleRequest internalRequest = new RethrottleRequest();
        internalRequest.setTaskId(new TaskId(request.param("taskId")));
        Float requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(request);
        if (requestsPerSecond == null) {
            throw new IllegalArgumentException("requests_per_second is a required parameter");
        }
        internalRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
        String groupBy = request.param("group_by", "nodes");
        return channel -> client.execute(RethrottleAction.INSTANCE, internalRequest, RestListTasksAction.listTasksResponseListener(this.nodesInCluster, groupBy, channel));
    }
}

