/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractGeoPointDVIndexFieldData;
import org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.LatLonPointFieldMapper;
import org.elasticsearch.index.mapper.LegacyDoubleFieldMapper;
import org.elasticsearch.index.mapper.LegacyGeoPointFieldMapper;
import org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.DocValueFormat;
import org.joda.time.DateTimeZone;

public abstract class BaseGeoPointFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    protected static final DeprecationLogger deprecationLogger = new DeprecationLogger(Loggers.getLogger(BaseGeoPointFieldMapper.class));
    protected FieldMapper latMapper;
    protected FieldMapper lonMapper;
    protected FieldMapper geoHashMapper;
    protected Explicit<Boolean> ignoreMalformed;

    protected BaseGeoPointFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper latMapper, FieldMapper lonMapper, FieldMapper geoHashMapper, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geoHashMapper = geoHashMapper;
        this.ignoreMalformed = ignoreMalformed;
    }

    public LegacyGeoPointFieldType legacyFieldType() {
        return (LegacyGeoPointFieldType)super.fieldType();
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        BaseGeoPointFieldMapper gpfmMergeWith = (BaseGeoPointFieldMapper)mergeWith;
        if (gpfmMergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gpfmMergeWith.ignoreMalformed;
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        if (!(this instanceof LatLonPointFieldMapper)) {
            return Iterators.concat(super.iterator(), this.legacyIterator());
        }
        return super.iterator();
    }

    public Iterator<Mapper> legacyIterator() {
        ArrayList<FieldMapper> extras = new ArrayList<FieldMapper>();
        if (this.legacyFieldType().isGeoHashEnabled()) {
            extras.add(this.geoHashMapper);
        }
        if (this.legacyFieldType().isLatLonEnabled()) {
            extras.add(this.latMapper);
            extras.add(this.lonMapper);
        }
        return extras.iterator();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected void parse(ParseContext context, GeoPoint point, String geoHash) throws IOException {
        if (this.legacyFieldType().isGeoHashEnabled()) {
            if (geoHash == null) {
                geoHash = GeoHashUtils.stringEncode(point.lon(), point.lat());
            }
            this.addGeoHashField(context, geoHash);
        }
        if (this.legacyFieldType().isLatLonEnabled()) {
            this.latMapper.parse(context.createExternalValueContext(point.lat()));
            this.lonMapper.parse(context.createExternalValueContext(point.lon()));
        }
        this.multiFields.parse(this, context.createExternalValueContext(point));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Mapper parse(ParseContext context) throws IOException {
        context.path().add(this.simpleName());
        sparse = context.parseExternalValue(GeoPoint.class);
        if (sparse != null) {
            this.parse(context, sparse, null);
        } else {
            sparse = new GeoPoint();
            token = context.parser().currentToken();
            if (token == XContentParser.Token.START_ARRAY) {
                token = context.parser().nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    while (token != XContentParser.Token.END_ARRAY) {
                        block22: {
                            try {
                                this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                            }
                            catch (ElasticsearchParseException e) {
                                if (this.ignoreMalformed.value().booleanValue()) break block22;
                                throw e;
                            }
                        }
                        token = context.parser().nextToken();
                    }
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    lon = context.parser().doubleValue();
                    token = context.parser().nextToken();
                    lat = context.parser().doubleValue();
                    while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parse(context, sparse.reset(lat, lon), null);
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        block23: {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                this.parsePointFromString(context, sparse, context.parser().text());
                            } else {
                                try {
                                    this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                                }
                                catch (ElasticsearchParseException e) {
                                    if (this.ignoreMalformed.value().booleanValue()) break block23;
                                    throw e;
                                }
                            }
                        }
                        token = context.parser().nextToken();
                    }
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                this.parsePointFromString(context, sparse, context.parser().text());
            } else if (token != XContentParser.Token.VALUE_NULL) {
                try {
                    this.parse(context, GeoUtils.parseGeoPoint(context.parser(), sparse), null);
                }
                catch (ElasticsearchParseException e) {
                    if (this.ignoreMalformed.value().booleanValue()) ** GOTO lbl54
                    throw e;
                }
            }
        }
lbl54:
        // 9 sources

        context.path().remove();
        return null;
    }

    private void addGeoHashField(ParseContext context, String geoHash) throws IOException {
        LegacyGeoPointFieldType ft = (LegacyGeoPointFieldType)this.fieldType;
        int len = Math.min(ft.geoHashPrecision(), geoHash.length());
        int min = ft.isGeoHashPrefixEnabled() ? 1 : len;
        for (int i = len; i >= min; --i) {
            this.geoHashMapper.parse(context.createExternalValueContext(geoHash.substring(0, i)));
        }
    }

    private void parsePointFromString(ParseContext context, GeoPoint sparse, String point) throws IOException {
        if (point.indexOf(44) < 0) {
            this.parse(context, sparse.resetFromGeoHash(point), point);
        } else {
            this.parse(context, sparse.resetFromString(point), null);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (!(this instanceof LatLonPointFieldMapper)) {
            this.legacyDoXContentBody(builder, includeDefaults, params);
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
    }

    protected void legacyDoXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        LegacyGeoPointFieldType ft = (LegacyGeoPointFieldType)this.fieldType;
        if (includeDefaults || ft.isLatLonEnabled()) {
            builder.field("lat_lon", ft.isLatLonEnabled());
        }
        if (ft.isLatLonEnabled() && (includeDefaults || ft.latFieldType().numericPrecisionStep() != 16)) {
            builder.field("precision_step", ft.latFieldType().numericPrecisionStep());
        }
        if (includeDefaults || ft.isGeoHashEnabled()) {
            builder.field("geohash", ft.isGeoHashEnabled());
        }
        if (includeDefaults || ft.isGeoHashPrefixEnabled()) {
            builder.field("geohash_prefix", ft.isGeoHashPrefixEnabled());
        }
        if (ft.isGeoHashEnabled() && (includeDefaults || ft.geoHashPrecision() != 12)) {
            builder.field("geohash_precision", ft.geoHashPrecision());
        }
    }

    @Override
    public FieldMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapper lonUpdated;
        BaseGeoPointFieldMapper updated = (BaseGeoPointFieldMapper)super.updateFieldType((Map)fullNameToFieldType);
        Mapper geoUpdated = this.geoHashMapper == null ? null : this.geoHashMapper.updateFieldType((Map)fullNameToFieldType);
        Mapper latUpdated = this.latMapper == null ? null : this.latMapper.updateFieldType((Map)fullNameToFieldType);
        Mapper mapper = lonUpdated = this.lonMapper == null ? null : this.lonMapper.updateFieldType((Map)fullNameToFieldType);
        if (updated == this && geoUpdated == this.geoHashMapper && latUpdated == this.latMapper && lonUpdated == this.lonMapper) {
            return this;
        }
        if (updated == this) {
            updated = (BaseGeoPointFieldMapper)updated.clone();
        }
        updated.geoHashMapper = geoUpdated;
        updated.latMapper = latUpdated;
        updated.lonMapper = lonUpdated;
        return updated;
    }

    public static class LegacyGeoPointFieldType
    extends GeoPointFieldType {
        protected MappedFieldType geoHashFieldType;
        protected int geoHashPrecision;
        protected boolean geoHashPrefixEnabled;
        protected MappedFieldType latFieldType;
        protected MappedFieldType lonFieldType;

        LegacyGeoPointFieldType() {
        }

        LegacyGeoPointFieldType(LegacyGeoPointFieldType ref) {
            super(ref);
            this.geoHashFieldType = ref.geoHashFieldType;
            this.geoHashPrecision = ref.geoHashPrecision;
            this.geoHashPrefixEnabled = ref.geoHashPrefixEnabled;
            this.latFieldType = ref.latFieldType;
            this.lonFieldType = ref.lonFieldType;
        }

        @Override
        public MappedFieldType clone() {
            return new LegacyGeoPointFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            LegacyGeoPointFieldType that = (LegacyGeoPointFieldType)o;
            return this.geoHashPrecision == that.geoHashPrecision && this.geoHashPrefixEnabled == that.geoHashPrefixEnabled && Objects.equals(this.geoHashFieldType, that.geoHashFieldType) && Objects.equals(this.latFieldType, that.latFieldType) && Objects.equals(this.lonFieldType, that.lonFieldType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.geoHashFieldType, this.geoHashPrecision, this.geoHashPrefixEnabled, this.latFieldType, this.lonFieldType);
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            LegacyGeoPointFieldType other = (LegacyGeoPointFieldType)fieldType;
            if (this.isLatLonEnabled() != other.isLatLonEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [lat_lon]");
            }
            if (this.isLatLonEnabled() && other.isLatLonEnabled() && this.latFieldType().numericPrecisionStep() != other.latFieldType().numericPrecisionStep()) {
                conflicts.add("mapper [" + this.name() + "] has different [precision_step]");
            }
            if (this.isGeoHashEnabled() != other.isGeoHashEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash]");
            }
            if (this.geoHashPrecision() != other.geoHashPrecision()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash_precision]");
            }
            if (this.isGeoHashPrefixEnabled() != other.isGeoHashPrefixEnabled()) {
                conflicts.add("mapper [" + this.name() + "] has different [geohash_prefix]");
            }
        }

        public boolean isGeoHashEnabled() {
            return this.geoHashFieldType != null;
        }

        public MappedFieldType geoHashFieldType() {
            return this.geoHashFieldType;
        }

        public int geoHashPrecision() {
            return this.geoHashPrecision;
        }

        public boolean isGeoHashPrefixEnabled() {
            return this.geoHashPrefixEnabled;
        }

        public void setGeoHashEnabled(MappedFieldType geoHashFieldType, int geoHashPrecision, boolean geoHashPrefixEnabled) {
            this.checkIfFrozen();
            this.geoHashFieldType = geoHashFieldType;
            this.geoHashPrecision = geoHashPrecision;
            this.geoHashPrefixEnabled = geoHashPrefixEnabled;
        }

        public boolean isLatLonEnabled() {
            return this.latFieldType != null;
        }

        public MappedFieldType latFieldType() {
            return this.latFieldType;
        }

        public MappedFieldType lonFieldType() {
            return this.lonFieldType;
        }

        public void setLatLonEnabled(MappedFieldType latFieldType, MappedFieldType lonFieldType) {
            this.checkIfFrozen();
            this.latFieldType = latFieldType;
            this.lonFieldType = lonFieldType;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            return new AbstractGeoPointDVIndexFieldData.Builder();
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.GEOHASH;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead: [" + this.name() + "]", new Object[0]);
        }

        @Override
        public FieldStats.GeoPoint stats(IndexReader reader) throws IOException {
            String field = this.name();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(field);
            if (fi == null) {
                return null;
            }
            Terms terms = MultiFields.getTerms(reader, field);
            if (terms == null) {
                return new FieldStats.GeoPoint(reader.maxDoc(), 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            GeoPoint minPt = GeoPoint.fromGeohash(NumericUtils.sortableBytesToLong(terms.getMin().bytes, terms.getMin().offset));
            GeoPoint maxPt = GeoPoint.fromGeohash(NumericUtils.sortableBytesToLong(terms.getMax().bytes, terms.getMax().offset));
            return new FieldStats.GeoPoint(reader.maxDoc(), terms.getDocCount(), -1L, terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), minPt, maxPt);
        }
    }

    public static abstract class GeoPointFieldType
    extends MappedFieldType {
        GeoPointFieldType() {
        }

        GeoPointFieldType(GeoPointFieldType ref) {
            super(ref);
        }

        @Override
        public String typeName() {
            return BaseGeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            return new FieldStats.Text(maxDoc, -1L, -1L, -1L, this.isSearchable(), this.isAggregatable());
        }
    }

    public static abstract class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Version indexVersionCreated = parserContext.indexVersionCreated();
            Builder builder = indexVersionCreated.before(Version.V_2_2_0) ? new LegacyGeoPointFieldMapper.Builder(name) : (indexVersionCreated.onOrAfter(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION) ? new LatLonPointFieldMapper.Builder(name) : new GeoPointFieldMapper.Builder(name));
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (indexVersionCreated.before(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION)) {
                    if (propName.equals("lat_lon")) {
                        deprecationLogger.deprecated("geo_point lat_lon parameter is deprecated and will be removed in the next major release", new Object[0]);
                        builder.enableLatLon(XContentMapValues.lenientNodeBooleanValue(propNode, propName));
                        iterator.remove();
                    } else if (propName.equals("precision_step")) {
                        deprecationLogger.deprecated("geo_point precision_step parameter is deprecated and will be removed in the next major release", new Object[0]);
                        builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                        iterator.remove();
                    } else if (propName.equals("geohash")) {
                        deprecationLogger.deprecated("geo_point geohash parameter is deprecated and will be removed in the next major release", new Object[0]);
                        builder.enableGeoHash(XContentMapValues.lenientNodeBooleanValue(propNode, propName));
                        iterator.remove();
                    } else if (propName.equals("geohash_prefix")) {
                        deprecationLogger.deprecated("geo_point geohash_prefix parameter is deprecated and will be removed in the next major release", new Object[0]);
                        builder.geoHashPrefix(XContentMapValues.lenientNodeBooleanValue(propNode, propName));
                        if (XContentMapValues.lenientNodeBooleanValue(propNode, propName)) {
                            builder.enableGeoHash(true);
                        }
                        iterator.remove();
                    } else if (propName.equals("geohash_precision")) {
                        deprecationLogger.deprecated("geo_point geohash_precision parameter is deprecated and will be removed in the next major release", new Object[0]);
                        if (propNode instanceof Integer) {
                            builder.geoHashPrecision(XContentMapValues.nodeIntegerValue(propNode));
                        } else {
                            builder.geoHashPrecision(GeoUtils.geoHashLevelsForPrecision(propNode.toString()));
                        }
                        iterator.remove();
                    }
                }
                if (!propName.equals("ignore_malformed")) continue;
                builder.ignoreMalformed(TypeParsers.nodeBooleanValue(name, "ignore_malformed", propNode));
                iterator.remove();
            }
            if (builder instanceof LegacyGeoPointFieldMapper.Builder) {
                return LegacyGeoPointFieldMapper.parse((LegacyGeoPointFieldMapper.Builder)builder, node, parserContext);
            }
            if (builder instanceof LatLonPointFieldMapper.Builder) {
                return (LatLonPointFieldMapper.Builder)builder;
            }
            return (GeoPointFieldMapper.Builder)builder;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends BaseGeoPointFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected boolean enableLatLon = false;
        protected Integer precisionStep;
        protected boolean enableGeoHash = false;
        protected boolean enableGeoHashPrefix = false;
        protected int geoHashPrecision = 12;
        protected Boolean ignoreMalformed;

        public Builder(String name, MappedFieldType fieldType) {
            super(name, fieldType, fieldType);
        }

        @Override
        public GeoPointFieldType fieldType() {
            return (GeoPointFieldType)this.fieldType;
        }

        public T enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return (T)((Builder)this.builder);
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrefix(boolean enableGeoHashPrefix) {
            this.enableGeoHashPrefix = enableGeoHashPrefix;
            return (T)((Builder)this.builder);
        }

        public T geoHashPrecision(int precision) {
            this.geoHashPrecision = precision;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public abstract Y build(Mapper.BuilderContext var1, String var2, MappedFieldType var3, MappedFieldType var4, Settings var5, FieldMapper var6, FieldMapper var7, FieldMapper var8, FieldMapper.MultiFields var9, Explicit<Boolean> var10, FieldMapper.CopyTo var11);

        @Override
        public Y build(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().before(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION)) {
                return this.buildLegacy(context);
            }
            return this.build(context, this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), null, null, null, this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.copyTo);
        }

        private Y buildLegacy(Mapper.BuilderContext context) {
            LegacyGeoPointFieldType geoPointFieldType = (LegacyGeoPointFieldType)this.fieldType;
            FieldMapper latMapper = null;
            FieldMapper lonMapper = null;
            context.path().add(this.name);
            if (this.enableLatLon) {
                if (context.indexCreatedVersion().before(Version.V_5_0_0_alpha2)) {
                    LegacyNumberFieldMapper.Builder latMapperBuilder = (LegacyNumberFieldMapper.Builder)new LegacyDoubleFieldMapper.Builder("lat").includeInAll(false);
                    LegacyNumberFieldMapper.Builder lonMapperBuilder = (LegacyNumberFieldMapper.Builder)new LegacyDoubleFieldMapper.Builder("lon").includeInAll(false);
                    if (this.precisionStep != null) {
                        latMapperBuilder.precisionStep(this.precisionStep);
                        lonMapperBuilder.precisionStep(this.precisionStep);
                    }
                    latMapper = (LegacyDoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((LegacyNumberFieldMapper.Builder)latMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                    lonMapper = (LegacyDoubleFieldMapper)((Mapper.Builder)((FieldMapper.Builder)((LegacyNumberFieldMapper.Builder)lonMapperBuilder.includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                } else {
                    latMapper = ((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)new NumberFieldMapper.Builder("lat", NumberFieldMapper.NumberType.DOUBLE).includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                    lonMapper = ((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)new NumberFieldMapper.Builder("lon", NumberFieldMapper.NumberType.DOUBLE).includeInAll(false)).store(this.fieldType.stored())).docValues(false)).build(context);
                }
                geoPointFieldType.setLatLonEnabled(latMapper.fieldType(), ((FieldMapper)lonMapper).fieldType());
            }
            FieldMapper geoHashMapper = null;
            if (this.enableGeoHash || this.enableGeoHashPrefix) {
                geoHashMapper = context.indexCreatedVersion().onOrAfter(Version.V_5_0_0_alpha1) ? ((KeywordFieldMapper.Builder)((KeywordFieldMapper.Builder)((KeywordFieldMapper.Builder)new KeywordFieldMapper.Builder("geohash").index(true)).includeInAll(false)).store(this.fieldType.stored())).build(context) : ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)new StringFieldMapper.Builder("geohash").tokenized(false)).index(true)).omitNorms(true)).indexOptions(IndexOptions.DOCS)).includeInAll(false)).store(this.fieldType.stored())).build(context);
                geoPointFieldType.setGeoHashEnabled(((FieldMapper)geoHashMapper).fieldType(), this.geoHashPrecision, this.enableGeoHashPrefix);
            }
            context.path().remove();
            return this.build(context, this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), latMapper, lonMapper, geoHashMapper, this.multiFieldsBuilder.build(this, context), this.ignoreMalformed(context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final boolean ENABLE_GEOHASH_PREFIX = false;
        public static final int GEO_HASH_PRECISION = 12;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }
}

