/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.BaseGatewayShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;

public abstract class PrimaryShardAllocator
extends BaseGatewayShardAllocator {
    private static final Function<String, String> INITIAL_SHARDS_PARSER = value -> {
        switch (value) {
            case "quorum": 
            case "quorum-1": 
            case "half": 
            case "one": 
            case "full": 
            case "full-1": 
            case "all-1": 
            case "all": {
                return value;
            }
        }
        Integer.parseInt(value);
        return value;
    };
    public static final Setting<String> NODE_INITIAL_SHARDS_SETTING = new Setting<String>("gateway.initial_shards", settings -> settings.get("gateway.local.initial_shards", "quorum"), INITIAL_SHARDS_PARSER, Setting.Property.Dynamic, Setting.Property.NodeScope);
    @Deprecated
    public static final Setting<String> INDEX_RECOVERY_INITIAL_SHARDS_SETTING = new Setting<String>("index.recovery.initial_shards", settings -> NODE_INITIAL_SHARDS_SETTING.get((Settings)settings), INITIAL_SHARDS_PARSER, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final Comparator<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> NO_STORE_EXCEPTION_FIRST_COMPARATOR = Comparator.comparing(state -> state.storeException() == null).reversed();
    private static final Comparator<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> PRIMARY_FIRST_COMPARATOR = Comparator.comparing(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards::primary).reversed();

    public PrimaryShardAllocator(Settings settings) {
        super(settings);
        this.logger.debug("using initial_shards [{}]", (Object)NODE_INITIAL_SHARDS_SETTING.get(settings));
    }

    private static boolean isResponsibleFor(ShardRouting shard) {
        return shard.primary() && shard.unassigned() && (shard.recoverySource().getType() == RecoverySource.Type.EXISTING_STORE || shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT);
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        DecidedNode decidedNode;
        boolean enoughAllocationsFound;
        NodeShardsResult nodeShardsResult;
        if (!PrimaryShardAllocator.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        boolean explain = allocation.debugDecision();
        AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = this.fetchData(unassignedShard, allocation);
        if (!shardState.hasData()) {
            allocation.setHasPendingAsyncFetch();
            List<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = this.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(unassignedShard.index());
        Set<String> inSyncAllocationIds = indexMetaData.inSyncAllocationIds(unassignedShard.id());
        boolean snapshotRestore = unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT;
        boolean recoverOnAnyNode = this.recoverOnAnyNode(indexMetaData);
        if (inSyncAllocationIds.isEmpty()) {
            assert (Version.indexCreated(indexMetaData.getSettings()).before(Version.V_5_0_0_alpha1)) : "trying to allocate a primary with an empty in sync allocation id set, but index is new. index: " + indexMetaData.getIndex();
            nodeShardsResult = PrimaryShardAllocator.buildVersionBasedNodeShardsResult(unassignedShard, snapshotRestore || recoverOnAnyNode, allocation.getIgnoreNodes(unassignedShard.shardId()), shardState, logger);
            enoughAllocationsFound = snapshotRestore || recoverOnAnyNode ? nodeShardsResult.allocationsFound > 0 : this.isEnoughVersionBasedAllocationsFound(indexMetaData, nodeShardsResult);
            logger.debug("[{}][{}]: version-based allocation for pre-{} index found {} allocations of {}", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)Version.V_5_0_0_alpha1, (Object)nodeShardsResult.allocationsFound, (Object)unassignedShard);
        } else {
            assert (!inSyncAllocationIds.isEmpty());
            nodeShardsResult = PrimaryShardAllocator.buildAllocationIdBasedNodeShardsResult(unassignedShard, snapshotRestore || recoverOnAnyNode, allocation.getIgnoreNodes(unassignedShard.shardId()), inSyncAllocationIds, shardState, logger);
            enoughAllocationsFound = nodeShardsResult.orderedAllocationCandidates.size() > 0;
            logger.debug("[{}][{}]: found {} allocation candidates of {} based on allocation ids: [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)nodeShardsResult.orderedAllocationCandidates.size(), (Object)unassignedShard, (Object)inSyncAllocationIds);
        }
        if (!enoughAllocationsFound) {
            if (snapshotRestore) {
                logger.debug("[{}][{}]: missing local data, will restore from [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard.recoverySource());
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            if (recoverOnAnyNode) {
                logger.debug("[{}][{}]: missing local data, recover from any node", (Object)unassignedShard.index(), (Object)unassignedShard.id());
                return AllocateUnassignedDecision.NOT_TAKEN;
            }
            logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)nodeShardsResult.allocationsFound);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, explain ? PrimaryShardAllocator.buildNodeDecisions(null, shardState, inSyncAllocationIds) : null);
        }
        NodesToAllocate nodesToAllocate = this.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, unassignedShard, false);
        DiscoveryNode node = null;
        String allocationId = null;
        boolean throttled = false;
        if (!nodesToAllocate.yesNodeShards.isEmpty()) {
            decidedNode = nodesToAllocate.yesNodeShards.get(0);
            logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)decidedNode.nodeShardState.getNode());
            node = decidedNode.nodeShardState.getNode();
            allocationId = decidedNode.nodeShardState.allocationId();
        } else if (nodesToAllocate.throttleNodeShards.isEmpty() && !nodesToAllocate.noNodeShards.isEmpty()) {
            nodesToAllocate = this.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, unassignedShard, true);
            if (!nodesToAllocate.yesNodeShards.isEmpty()) {
                decidedNode = nodesToAllocate.yesNodeShards.get(0);
                TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState = decidedNode.nodeShardState;
                logger.debug("[{}][{}]: allocating [{}] to [{}] on forced primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeShardState.getNode());
                node = nodeShardState.getNode();
                allocationId = nodeShardState.allocationId();
            } else if (!nodesToAllocate.throttleNodeShards.isEmpty()) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on forced primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodesToAllocate.throttleNodeShards);
                throttled = true;
            } else {
                logger.debug("[{}][{}]: forced primary allocation denied [{}]", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard);
            }
        } else {
            logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodesToAllocate.throttleNodeShards);
            throttled = true;
        }
        List<NodeAllocationResult> nodeResults = null;
        if (explain) {
            nodeResults = PrimaryShardAllocator.buildNodeDecisions(nodesToAllocate, shardState, inSyncAllocationIds);
        }
        if (allocation.hasPendingAsyncFetch()) {
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeResults);
        }
        if (node != null) {
            return AllocateUnassignedDecision.yes(node, allocationId, nodeResults, false);
        }
        if (throttled) {
            return AllocateUnassignedDecision.throttle(nodeResults);
        }
        return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DECIDERS_NO, nodeResults, true);
    }

    private static List<NodeAllocationResult> buildNodeDecisions(NodesToAllocate nodesToAllocate, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchedShardData, Set<String> inSyncAllocationIds) {
        Collection ineligibleShards;
        ArrayList<NodeAllocationResult> nodeResults = new ArrayList<NodeAllocationResult>();
        if (nodesToAllocate != null) {
            HashSet discoNodes = new HashSet();
            nodeResults.addAll(Stream.of(nodesToAllocate.yesNodeShards, nodesToAllocate.throttleNodeShards, nodesToAllocate.noNodeShards).flatMap(Collection::stream).map(dnode -> {
                discoNodes.add(dnode.nodeShardState.getNode());
                return new NodeAllocationResult(dnode.nodeShardState.getNode(), PrimaryShardAllocator.shardStoreInfo(dnode.nodeShardState, inSyncAllocationIds), dnode.decision);
            }).collect(Collectors.toList()));
            ineligibleShards = fetchedShardData.getData().values().stream().filter(shardData -> !discoNodes.contains(shardData.getNode())).collect(Collectors.toList());
        } else {
            ineligibleShards = fetchedShardData.getData().values();
        }
        nodeResults.addAll(ineligibleShards.stream().map(shardData -> new NodeAllocationResult(shardData.getNode(), PrimaryShardAllocator.shardStoreInfo(shardData, inSyncAllocationIds), null)).collect(Collectors.toList()));
        return nodeResults;
    }

    private static NodeAllocationResult.ShardStoreInfo shardStoreInfo(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState, Set<String> inSyncAllocationIds) {
        Exception storeErr = nodeShardState.storeException();
        boolean inSync = nodeShardState.allocationId() != null && inSyncAllocationIds.contains(nodeShardState.allocationId());
        return new NodeAllocationResult.ShardStoreInfo(nodeShardState.allocationId(), inSync, storeErr);
    }

    protected static NodeShardsResult buildAllocationIdBasedNodeShardsResult(ShardRouting shard, boolean matchAnyShard, Set<String> ignoreNodes, Set<String> inSyncAllocationIds, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState, Logger logger) {
        Comparator<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> comparator;
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> nodeShardStates = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        int numberOfAllocationsFound = 0;
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : shardState.getData().values()) {
            DiscoveryNode node = nodeShardState.getNode();
            String allocationId = nodeShardState.allocationId();
            if (ignoreNodes.contains(node.getId())) continue;
            if (nodeShardState.storeException() == null) {
                if (allocationId == null && nodeShardState.legacyVersion() == -1L) {
                    logger.trace("[{}] on node [{}] has no shard state information", (Object)shard, (Object)nodeShardState.getNode());
                } else if (allocationId != null) {
                    assert (nodeShardState.legacyVersion() == -1L) : "Allocation id and legacy version cannot be both present";
                    logger.trace("[{}] on node [{}] has allocation id [{}]", (Object)shard, (Object)nodeShardState.getNode(), (Object)allocationId);
                } else {
                    logger.trace("[{}] on node [{}] has no allocation id, out-dated shard (shard state version: [{}])", (Object)shard, (Object)nodeShardState.getNode(), (Object)nodeShardState.legacyVersion());
                }
            } else {
                String finalAllocationId = allocationId;
                if (nodeShardState.storeException() instanceof ShardLockObtainFailedException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has allocation id [{}] but the store can not be opened as it's locked, treating as valid shard", shard, nodeShardState.getNode(), finalAllocationId), (Throwable)nodeShardState.storeException());
                } else {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has allocation id [{}] but the store can not be opened, treating as no allocation id", shard, nodeShardState.getNode(), finalAllocationId), (Throwable)nodeShardState.storeException());
                    allocationId = null;
                }
            }
            if (allocationId == null) continue;
            assert (nodeShardState.storeException() == null || nodeShardState.storeException() instanceof ShardLockObtainFailedException) : "only allow store that can be opened or that throws a ShardLockObtainFailedException while being opened but got a store throwing " + nodeShardState.storeException();
            ++numberOfAllocationsFound;
            if (!matchAnyShard && !inSyncAllocationIds.contains(nodeShardState.allocationId())) continue;
            nodeShardStates.add(nodeShardState);
        }
        if (matchAnyShard) {
            Comparator<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> matchingAllocationsFirst = Comparator.comparing(state -> inSyncAllocationIds.contains(state.allocationId())).reversed();
            comparator = matchingAllocationsFirst.thenComparing(NO_STORE_EXCEPTION_FIRST_COMPARATOR).thenComparing(PRIMARY_FIRST_COMPARATOR);
        } else {
            comparator = NO_STORE_EXCEPTION_FIRST_COMPARATOR.thenComparing(PRIMARY_FIRST_COMPARATOR);
        }
        nodeShardStates.sort(comparator);
        if (logger.isTraceEnabled()) {
            logger.trace("{} candidates for allocation: {}", (Object)shard, (Object)nodeShardStates.stream().map(s -> s.getNode().getName()).collect(Collectors.joining(", ")));
        }
        return new NodeShardsResult(nodeShardStates, numberOfAllocationsFound);
    }

    private boolean isEnoughVersionBasedAllocationsFound(IndexMetaData indexMetaData, NodeShardsResult nodeShardsResult) {
        int requiredAllocation = 1;
        String initialShards = INDEX_RECOVERY_INITIAL_SHARDS_SETTING.get(indexMetaData.getSettings(), this.settings);
        if ("quorum".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 1) {
                requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2 + 1;
            }
        } else if ("quorum-1".equals(initialShards) || "half".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 2) {
                requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2;
            }
        } else if ("one".equals(initialShards)) {
            requiredAllocation = 1;
        } else if ("full".equals(initialShards) || "all".equals(initialShards)) {
            requiredAllocation = indexMetaData.getNumberOfReplicas() + 1;
        } else if ("full-1".equals(initialShards) || "all-1".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 1) {
                requiredAllocation = indexMetaData.getNumberOfReplicas();
            }
        } else {
            requiredAllocation = Integer.parseInt(initialShards);
        }
        return nodeShardsResult.allocationsFound >= requiredAllocation;
    }

    private NodesToAllocate buildNodesToAllocate(RoutingAllocation allocation, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> nodeShardStates, ShardRouting shardRouting, boolean forceAllocate) {
        ArrayList<DecidedNode> yesNodeShards = new ArrayList<DecidedNode>();
        ArrayList<DecidedNode> throttledNodeShards = new ArrayList<DecidedNode>();
        ArrayList<DecidedNode> noNodeShards = new ArrayList<DecidedNode>();
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : nodeShardStates) {
            RoutingNode node = allocation.routingNodes().node(nodeShardState.getNode().getId());
            if (node == null) continue;
            Decision decision = forceAllocate ? allocation.deciders().canForceAllocatePrimary(shardRouting, node, allocation) : allocation.deciders().canAllocate(shardRouting, node, allocation);
            DecidedNode decidedNode = new DecidedNode(nodeShardState, decision);
            if (decision.type() == Decision.Type.THROTTLE) {
                throttledNodeShards.add(decidedNode);
                continue;
            }
            if (decision.type() == Decision.Type.NO) {
                noNodeShards.add(decidedNode);
                continue;
            }
            yesNodeShards.add(decidedNode);
        }
        return new NodesToAllocate(Collections.unmodifiableList(yesNodeShards), Collections.unmodifiableList(throttledNodeShards), Collections.unmodifiableList(noNodeShards));
    }

    static NodeShardsResult buildVersionBasedNodeShardsResult(ShardRouting shard, boolean matchAnyShard, Set<String> ignoreNodes, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState, Logger logger) {
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> allocationCandidates = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        int numberOfAllocationsFound = 0;
        long highestVersion = -1L;
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : shardState.getData().values()) {
            long version = nodeShardState.legacyVersion();
            DiscoveryNode node = nodeShardState.getNode();
            if (ignoreNodes.contains(node.getId())) continue;
            if (nodeShardState.storeException() == null) {
                if (version == -1L && nodeShardState.allocationId() == null) {
                    logger.trace("[{}] on node [{}] has no shard state information", (Object)shard, (Object)nodeShardState.getNode());
                } else if (version != -1L) {
                    assert (nodeShardState.allocationId() == null) : "Allocation id and legacy version cannot be both present";
                    logger.trace("[{}] on node [{}] has version [{}] of shard", (Object)shard, (Object)nodeShardState.getNode(), (Object)version);
                } else {
                    version = Long.MAX_VALUE;
                    logger.trace("[{}] on node [{}] has allocation id [{}]", (Object)shard, (Object)nodeShardState.getNode(), (Object)nodeShardState.allocationId());
                }
            } else {
                long finalVersion = version;
                if (nodeShardState.storeException() instanceof ShardLockObtainFailedException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has version [{}] but the store can not be opened as it's locked, treating as valid shard", shard, nodeShardState.getNode(), finalVersion), (Throwable)nodeShardState.storeException());
                    version = nodeShardState.allocationId() != null ? Long.MAX_VALUE : 0L;
                } else {
                    logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has version [{}] but the store can not be opened, treating no version", shard, nodeShardState.getNode(), finalVersion), (Throwable)nodeShardState.storeException());
                    version = -1L;
                }
            }
            if (version == -1L) continue;
            ++numberOfAllocationsFound;
            if (version > highestVersion) {
                highestVersion = version;
                if (!matchAnyShard) {
                    allocationCandidates.clear();
                }
                allocationCandidates.add(nodeShardState);
                continue;
            }
            if (version != highestVersion) continue;
            allocationCandidates.add(nodeShardState);
        }
        CollectionUtil.timSort(allocationCandidates, Comparator.comparing(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards::legacyVersion).reversed());
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("[");
            for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards n : allocationCandidates) {
                sb.append("[").append(n.getNode().getName()).append("]").append(" -> ").append(n.legacyVersion()).append(", ");
            }
            sb.append("]");
            logger.trace("{} candidates for allocation: {}", (Object)shard, (Object)sb.toString());
        }
        return new NodeShardsResult(Collections.unmodifiableList(allocationCandidates), numberOfAllocationsFound);
    }

    private boolean recoverOnAnyNode(IndexMetaData metaData) {
        return !(!IndexMetaData.isOnSharedFilesystem(metaData.getSettings()) && !IndexMetaData.isOnSharedFilesystem(this.settings) || metaData.getSettings().getAsBoolean("index.shared_filesystem.recover_on_any_node", false) == false && this.settings.getAsBoolean("index.shared_filesystem.recover_on_any_node", false) == false);
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting var1, RoutingAllocation var2);

    private static class DecidedNode {
        final TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState;
        final Decision decision;

        private DecidedNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState, Decision decision) {
            this.nodeShardState = nodeShardState;
            this.decision = decision;
        }
    }

    static class NodesToAllocate {
        final List<DecidedNode> yesNodeShards;
        final List<DecidedNode> throttleNodeShards;
        final List<DecidedNode> noNodeShards;

        NodesToAllocate(List<DecidedNode> yesNodeShards, List<DecidedNode> throttleNodeShards, List<DecidedNode> noNodeShards) {
            this.yesNodeShards = yesNodeShards;
            this.throttleNodeShards = throttleNodeShards;
            this.noNodeShards = noNodeShards;
        }
    }

    private static class NodeShardsResult {
        final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> orderedAllocationCandidates;
        final int allocationsFound;

        NodeShardsResult(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> orderedAllocationCandidates, int allocationsFound) {
            this.orderedAllocationCandidates = orderedAllocationCandidates;
            this.allocationsFound = allocationsFound;
        }
    }
}

