/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.IndexFolderUpgrader;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.plugins.MetaDataUpgrader;

public class GatewayMetaState
extends AbstractComponent
implements ClusterStateApplier {
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    @Nullable
    private volatile MetaData previousMetaData;
    private volatile Set<Index> previouslyWrittenIndices = Collections.emptySet();

    @Inject
    public GatewayMetaState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, TransportNodesListGatewayMetaState nodesListGatewayMetaState, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        nodesListGatewayMetaState.init(this);
        if (DiscoveryNode.isDataNode(settings)) {
            this.ensureNoPre019ShardState(nodeEnv);
        }
        if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings)) {
            nodeEnv.ensureAtomicMoveSupported();
        }
        if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings)) {
            try {
                this.ensureNoPre019State();
                IndexFolderUpgrader.upgradeIndicesIfNeeded(settings, nodeEnv);
                MetaData metaData = metaStateService.loadFullState();
                MetaData upgradedMetaData = GatewayMetaState.upgradeMetaData(metaData, metaDataIndexUpgradeService, metaDataUpgrader);
                if (metaData != upgradedMetaData) {
                    if (!MetaData.isGlobalStateEquals(metaData, upgradedMetaData)) {
                        metaStateService.writeGlobalState("upgrade", upgradedMetaData);
                    }
                    for (IndexMetaData indexMetaData : upgradedMetaData) {
                        if (metaData.hasIndexMetaData(indexMetaData)) continue;
                        metaStateService.writeIndex("upgrade", indexMetaData);
                    }
                }
                long startNS = System.nanoTime();
                metaStateService.loadFullState();
                this.logger.debug("took {} to load state", (Object)TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - startNS)));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state, exiting...", (Throwable)e);
                throw e;
            }
        }
    }

    public MetaData loadMetaState() throws Exception {
        return this.metaStateService.loadFullState();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            this.previousMetaData = null;
            this.previouslyWrittenIndices = Collections.emptySet();
            return;
        }
        MetaData newMetaData = state.metaData();
        Set<Index> relevantIndices = Collections.emptySet();
        boolean success = true;
        if (state.nodes().getLocalNode().isMasterNode() || state.nodes().getLocalNode().isDataNode()) {
            if (this.previousMetaData == null) {
                try {
                    if (GatewayMetaState.isDataOnlyNode(state)) {
                        HashSet<Index> newPreviouslyWrittenIndices = new HashSet<Index>(this.previouslyWrittenIndices.size());
                        for (IndexMetaData indexMetaData : newMetaData) {
                            IndexMetaData indexMetaDataOnDisk = null;
                            if (indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE)) {
                                indexMetaDataOnDisk = this.metaStateService.loadIndexState(indexMetaData.getIndex());
                            }
                            if (indexMetaDataOnDisk == null) continue;
                            newPreviouslyWrittenIndices.add(indexMetaDataOnDisk.getIndex());
                        }
                        newPreviouslyWrittenIndices.addAll(this.previouslyWrittenIndices);
                        this.previouslyWrittenIndices = Collections.unmodifiableSet(newPreviouslyWrittenIndices);
                    }
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (this.previousMetaData == null || !MetaData.isGlobalStateEquals(this.previousMetaData, newMetaData)) {
                try {
                    this.metaStateService.writeGlobalState("changed", newMetaData);
                }
                catch (Exception e) {
                    success = false;
                }
            }
            relevantIndices = GatewayMetaState.getRelevantIndices(event.state(), event.previousState(), this.previouslyWrittenIndices);
            Iterable<IndexMetaWriteInfo> writeInfo = GatewayMetaState.resolveStatesToBeWritten(this.previouslyWrittenIndices, relevantIndices, this.previousMetaData, event.state().metaData());
            for (IndexMetaWriteInfo indexMetaWrite : writeInfo) {
                try {
                    this.metaStateService.writeIndex(indexMetaWrite.reason, indexMetaWrite.newMetaData);
                }
                catch (Exception e) {
                    success = false;
                }
            }
        }
        if (success) {
            this.previousMetaData = newMetaData;
            this.previouslyWrittenIndices = Collections.unmodifiableSet(relevantIndices);
        }
    }

    public static Set<Index> getRelevantIndices(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        Set<Index> relevantIndices = GatewayMetaState.isDataOnlyNode(state) ? GatewayMetaState.getRelevantIndicesOnDataOnlyNode(state, previousState, previouslyWrittenIndices) : (state.nodes().getLocalNode().isMasterNode() ? GatewayMetaState.getRelevantIndicesForMasterEligibleNode(state) : Collections.emptySet());
        return relevantIndices;
    }

    protected static boolean isDataOnlyNode(ClusterState state) {
        return !state.nodes().getLocalNode().isMasterNode() && state.nodes().getLocalNode().isDataNode();
    }

    private void ensureNoPre019State() throws Exception {
        for (Path dataLocation : this.nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation);){
                for (Path stateFile : stream) {
                    String name;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("[upgrade]: processing [{}]", (Object)stateFile.getFileName());
                    }
                    if (!(name = stateFile.getFileName().toString()).startsWith("metadata-")) continue;
                    throw new IllegalStateException("Detected pre 0.19 metadata file please upgrade to a version before " + Version.CURRENT.minimumCompatibilityVersion() + " first to upgrade state structures - metadata found: [" + stateFile.getParent().toAbsolutePath());
                }
            }
        }
    }

    static MetaData upgradeMetaData(MetaData metaData, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws Exception {
        boolean changed = false;
        MetaData.Builder upgradedMetaData = MetaData.builder(metaData);
        for (Object indexMetaData : metaData) {
            IndexMetaData indexMetaData2;
            changed |= indexMetaData != (indexMetaData2 = metaDataIndexUpgradeService.upgradeIndexMetaData((IndexMetaData)indexMetaData, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetaData.put(indexMetaData2, false);
        }
        HashMap existingCustoms = new HashMap();
        for (ObjectObjectCursor objectObjectCursor : metaData.customs()) {
            existingCustoms.put(objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)metaDataUpgrader.customMetaDataUpgraders.apply(existingCustoms);
        if (!upgradedCustoms.equals(existingCustoms)) {
            existingCustoms.keySet().forEach(upgradedMetaData::removeCustom);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                upgradedMetaData.putCustom((String)upgradedCustomEntry.getKey(), (MetaData.Custom)upgradedCustomEntry.getValue());
            }
            changed = true;
        }
        return changed ? upgradedMetaData.build() : metaData;
    }

    private void ensureNoPre019ShardState(NodeEnvironment nodeEnv) throws Exception {
        for (Path dataLocation : nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation, "shards-*");){
                Iterator<Path> iterator = stream.iterator();
                if (!iterator.hasNext()) continue;
                Path stateFile = iterator.next();
                throw new IllegalStateException("Detected pre 0.19 shard state file please upgrade to a version before " + Version.CURRENT.minimumCompatibilityVersion() + " first to upgrade state structures - shard state found: [" + stateFile.getParent().toAbsolutePath());
            }
        }
    }

    public static Iterable<IndexMetaWriteInfo> resolveStatesToBeWritten(Set<Index> previouslyWrittenIndices, Set<Index> potentiallyUnwrittenIndices, MetaData previousMetaData, MetaData newMetaData) {
        ArrayList<IndexMetaWriteInfo> indicesToWrite = new ArrayList<IndexMetaWriteInfo>();
        for (Index index : potentiallyUnwrittenIndices) {
            IndexMetaData newIndexMetaData = newMetaData.getIndexSafe(index);
            IndexMetaData previousIndexMetaData = previousMetaData == null ? null : previousMetaData.index(index);
            String writeReason = null;
            if (!previouslyWrittenIndices.contains(index) || previousIndexMetaData == null) {
                writeReason = "freshly created";
            } else if (previousIndexMetaData.getVersion() != newIndexMetaData.getVersion()) {
                writeReason = "version changed from [" + previousIndexMetaData.getVersion() + "] to [" + newIndexMetaData.getVersion() + "]";
            }
            if (writeReason == null) continue;
            indicesToWrite.add(new IndexMetaWriteInfo(newIndexMetaData, previousIndexMetaData, writeReason));
        }
        return indicesToWrite;
    }

    public static Set<Index> getRelevantIndicesOnDataOnlyNode(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        RoutingNode newRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (newRoutingNode == null) {
            throw new IllegalStateException("cluster state does not contain this node - cannot write index meta state");
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (ShardRouting routing : newRoutingNode) {
            indices.add(routing.index());
        }
        for (IndexMetaData indexMetaData : state.metaData()) {
            boolean isOrWasClosed = indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            IndexMetaData previousMetaData = previousState.metaData().index(indexMetaData.getIndex());
            if (previousMetaData != null) {
                boolean bl = isOrWasClosed = isOrWasClosed || previousMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            }
            if (!previouslyWrittenIndices.contains(indexMetaData.getIndex()) || !isOrWasClosed) continue;
            indices.add(indexMetaData.getIndex());
        }
        return indices;
    }

    public static Set<Index> getRelevantIndicesForMasterEligibleNode(ClusterState state) {
        HashSet<Index> relevantIndices = new HashSet<Index>();
        for (IndexMetaData indexMetaData : state.metaData()) {
            relevantIndices.add(indexMetaData.getIndex());
        }
        return relevantIndices;
    }

    public static class IndexMetaWriteInfo {
        final IndexMetaData newMetaData;
        final String reason;
        final IndexMetaData previousMetaData;

        public IndexMetaWriteInfo(IndexMetaData newMetaData, IndexMetaData previousMetaData, String reason) {
            this.newMetaData = newMetaData;
            this.reason = reason;
            this.previousMetaData = previousMetaData;
        }

        public IndexMetaData getNewMetaData() {
            return this.newMetaData;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

