/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version {
    public static final int V_2_0_0_beta1_ID = 2000001;
    public static final Version V_2_0_0_beta1 = new Version(2000001, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_0_0_beta2_ID = 2000002;
    public static final Version V_2_0_0_beta2 = new Version(2000002, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_0_0_rc1_ID = 2000051;
    public static final Version V_2_0_0_rc1 = new Version(2000051, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_0_0_ID = 2000099;
    public static final Version V_2_0_0 = new Version(2000099, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_0_1_ID = 2000199;
    public static final Version V_2_0_1 = new Version(2000199, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_0_2_ID = 2000299;
    public static final Version V_2_0_2 = new Version(2000299, org.apache.lucene.util.Version.LUCENE_5_2_1);
    public static final int V_2_1_0_ID = 2010099;
    public static final Version V_2_1_0 = new Version(2010099, org.apache.lucene.util.Version.LUCENE_5_3_1);
    public static final int V_2_1_1_ID = 2010199;
    public static final Version V_2_1_1 = new Version(2010199, org.apache.lucene.util.Version.LUCENE_5_3_1);
    public static final int V_2_1_2_ID = 2010299;
    public static final Version V_2_1_2 = new Version(2010299, org.apache.lucene.util.Version.LUCENE_5_3_1);
    public static final int V_2_2_0_ID = 2020099;
    public static final Version V_2_2_0 = new Version(2020099, org.apache.lucene.util.Version.LUCENE_5_4_1);
    public static final int V_2_2_1_ID = 2020199;
    public static final Version V_2_2_1 = new Version(2020199, org.apache.lucene.util.Version.LUCENE_5_4_1);
    public static final int V_2_2_2_ID = 2020299;
    public static final Version V_2_2_2 = new Version(2020299, org.apache.lucene.util.Version.LUCENE_5_4_1);
    public static final int V_2_3_0_ID = 2030099;
    public static final Version V_2_3_0 = new Version(2030099, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_3_1_ID = 2030199;
    public static final Version V_2_3_1 = new Version(2030199, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_3_2_ID = 2030299;
    public static final Version V_2_3_2 = new Version(2030299, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_3_3_ID = 2030399;
    public static final Version V_2_3_3 = new Version(2030399, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_3_4_ID = 2030499;
    public static final Version V_2_3_4 = new Version(2030499, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_3_5_ID = 2030599;
    public static final Version V_2_3_5 = new Version(2030599, org.apache.lucene.util.Version.LUCENE_5_5_0);
    public static final int V_2_4_0_ID = 2040099;
    public static final Version V_2_4_0 = new Version(2040099, org.apache.lucene.util.Version.LUCENE_5_5_2);
    public static final int V_2_4_1_ID = 2040199;
    public static final Version V_2_4_1 = new Version(2040199, org.apache.lucene.util.Version.LUCENE_5_5_2);
    public static final int V_2_4_2_ID = 2040299;
    public static final Version V_2_4_2 = new Version(2040299, org.apache.lucene.util.Version.LUCENE_5_5_2);
    public static final int V_2_4_3_ID = 2040399;
    public static final Version V_2_4_3 = new Version(2040399, org.apache.lucene.util.Version.LUCENE_5_5_2);
    public static final int V_2_4_4_ID = 2040499;
    public static final Version V_2_4_4 = new Version(2040499, org.apache.lucene.util.Version.LUCENE_5_5_2);
    public static final int V_5_0_0_alpha1_ID = 5000001;
    public static final Version V_5_0_0_alpha1 = new Version(5000001, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha2_ID = 5000002;
    public static final Version V_5_0_0_alpha2 = new Version(5000002, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha3_ID = 5000003;
    public static final Version V_5_0_0_alpha3 = new Version(5000003, org.apache.lucene.util.Version.LUCENE_6_0_0);
    public static final int V_5_0_0_alpha4_ID = 0x4C4B44;
    public static final Version V_5_0_0_alpha4 = new Version(0x4C4B44, org.apache.lucene.util.Version.LUCENE_6_1_0);
    public static final int V_5_0_0_alpha5_ID = 5000005;
    public static final Version V_5_0_0_alpha5 = new Version(5000005, org.apache.lucene.util.Version.LUCENE_6_1_0);
    public static final int V_5_0_0_beta1_ID = 5000026;
    public static final Version V_5_0_0_beta1 = new Version(5000026, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_0_rc1_ID = 5000051;
    public static final Version V_5_0_0_rc1 = new Version(5000051, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_0_ID = 5000099;
    public static final Version V_5_0_0 = new Version(5000099, org.apache.lucene.util.Version.LUCENE_6_2_0);
    public static final int V_5_0_1_ID = 5000199;
    public static final Version V_5_0_1 = new Version(5000199, org.apache.lucene.util.Version.LUCENE_6_2_1);
    public static final int V_5_0_2_ID = 5000299;
    public static final Version V_5_0_2 = new Version(5000299, org.apache.lucene.util.Version.LUCENE_6_2_1);
    public static final int V_5_0_3_ID_UNRELEASED = 0x4C4CCF;
    public static final Version V_5_0_3_UNRELEASED = new Version(0x4C4CCF, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_1_1_ID_UNRELEASED = 5010199;
    public static final Version V_5_1_1_UNRELEASED = new Version(5010199, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_1_2_ID_UNRELEASED = 5010299;
    public static final Version V_5_1_2_UNRELEASED = new Version(5010299, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_1_3_ID_UNRELEASED = 5010399;
    public static final Version V_5_1_3_UNRELEASED = new Version(5010399, org.apache.lucene.util.Version.LUCENE_6_3_0);
    public static final int V_5_2_0_ID_UNRELEASED = 5020099;
    public static final Version V_5_2_0_UNRELEASED = new Version(5020099, org.apache.lucene.util.Version.LUCENE_6_4_0);
    public static final int V_5_2_1_ID_UNRELEASED = 5020199;
    public static final Version V_5_2_1_UNRELEASED = new Version(5020199, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_2_2_ID_UNRELEASED = 5020299;
    public static final Version V_5_2_2_UNRELEASED = new Version(5020299, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_2_3_ID_UNRELEASED = 5020399;
    public static final Version V_5_2_3_UNRELEASED = new Version(5020399, org.apache.lucene.util.Version.LUCENE_6_4_1);
    public static final int V_5_3_0_ID_UNRELEASED = 5030099;
    public static final Version V_5_3_0_UNRELEASED;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        switch (id) {
            case 5030099: {
                return V_5_3_0_UNRELEASED;
            }
            case 5020399: {
                return V_5_2_3_UNRELEASED;
            }
            case 5020299: {
                return V_5_2_2_UNRELEASED;
            }
            case 5020199: {
                return V_5_2_1_UNRELEASED;
            }
            case 5020099: {
                return V_5_2_0_UNRELEASED;
            }
            case 5010399: {
                return V_5_1_3_UNRELEASED;
            }
            case 5010299: {
                return V_5_1_2_UNRELEASED;
            }
            case 5010199: {
                return V_5_1_1_UNRELEASED;
            }
            case 0x4C4CCF: {
                return V_5_0_3_UNRELEASED;
            }
            case 5000299: {
                return V_5_0_2;
            }
            case 5000199: {
                return V_5_0_1;
            }
            case 5000099: {
                return V_5_0_0;
            }
            case 5000051: {
                return V_5_0_0_rc1;
            }
            case 5000026: {
                return V_5_0_0_beta1;
            }
            case 5000005: {
                return V_5_0_0_alpha5;
            }
            case 0x4C4B44: {
                return V_5_0_0_alpha4;
            }
            case 5000003: {
                return V_5_0_0_alpha3;
            }
            case 5000002: {
                return V_5_0_0_alpha2;
            }
            case 5000001: {
                return V_5_0_0_alpha1;
            }
            case 2040499: {
                return V_2_4_4;
            }
            case 2040399: {
                return V_2_4_3;
            }
            case 2040299: {
                return V_2_4_2;
            }
            case 2040199: {
                return V_2_4_1;
            }
            case 2040099: {
                return V_2_4_0;
            }
            case 2030599: {
                return V_2_3_5;
            }
            case 2030499: {
                return V_2_3_4;
            }
            case 2030399: {
                return V_2_3_3;
            }
            case 2030299: {
                return V_2_3_2;
            }
            case 2030199: {
                return V_2_3_1;
            }
            case 2030099: {
                return V_2_3_0;
            }
            case 2020299: {
                return V_2_2_2;
            }
            case 2020199: {
                return V_2_2_1;
            }
            case 2020099: {
                return V_2_2_0;
            }
            case 2010299: {
                return V_2_1_2;
            }
            case 2010199: {
                return V_2_1_1;
            }
            case 2010099: {
                return V_2_1_0;
            }
            case 2000299: {
                return V_2_0_2;
            }
            case 2000199: {
                return V_2_0_1;
            }
            case 2000099: {
                return V_2_0_0;
            }
            case 2000051: {
                return V_2_0_0_rc1;
            }
            case 2000002: {
                return V_2_0_0_beta2;
            }
            case 2000001: {
                return V_2_0_0_beta1;
            }
        }
        return new Version(id, org.apache.lucene.util.Version.LATEST);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = indexSettings.getAsVersion("index.version.created", null);
        if (indexVersion == null) {
            throw new IllegalStateException("[index.version.created] is not present in the index settings for index with uuid: [" + indexSettings.get("index.uuid") + "]");
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    @Deprecated
    public static Version smallest(Version version1, Version version2) {
        return Version.min(version1, version2);
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        String[] parts;
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("\\.|\\-")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a beta build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = luceneVersion;
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    public Version minimumCompatibilityVersion() {
        byte bwcMinor;
        int bwcMajor;
        if (this.major >= 6) {
            bwcMajor = this.major - 1;
            bwcMinor = Version.CURRENT.minor;
        } else {
            bwcMajor = this.major;
            bwcMinor = 0;
        }
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + bwcMinor * 10000 + 99));
    }

    public Version minimumIndexCompatibilityVersion() {
        int bwcMajor = this.major == 5 ? 2 : this.major - 1;
        int bwcMinor = bwcMajor <= 2 ? 1 : 99;
        return Version.min(this, Version.fromId(bwcMajor * 1000000 + bwcMinor));
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        System.out.println("Version: " + CURRENT + ", Build: " + Build.CURRENT.shortHash() + "/" + Build.CURRENT.date() + ", JVM: " + JvmInfo.jvmInfo().version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    static {
        CURRENT = V_5_3_0_UNRELEASED = new Version(5030099, org.apache.lucene.util.Version.LUCENE_6_4_1);
        assert (Version.CURRENT.luceneVersion.equals(org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
    }
}

